// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueUpdateParameterProperties;
import java.io.IOException;
import java.util.List;

/**
 * NamedValue update Parameters.
 */
@Fluent
public final class NamedValueUpdateParameters implements JsonSerializable<NamedValueUpdateParameters> {
    /*
     * NamedValue entity Update contract properties.
     */
    private NamedValueUpdateParameterProperties innerProperties;

    /**
     * Creates an instance of NamedValueUpdateParameters class.
     */
    public NamedValueUpdateParameters() {
    }

    /**
     * Get the innerProperties property: NamedValue entity Update contract properties.
     * 
     * @return the innerProperties value.
     */
    private NamedValueUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the displayName property: Unique name of NamedValue. It may contain only letters, digits, period, dash, and
     * underscore characters.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Unique name of NamedValue. It may contain only letters, digits, period, dash, and
     * underscore characters.
     * 
     * @param displayName the displayName value to set.
     * @return the NamedValueUpdateParameters object itself.
     */
    public NamedValueUpdateParameters withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueUpdateParameterProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the value property: Value of the NamedValue. Can contain policy expressions. It may not be empty or consist
     * only of whitespace.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: Value of the NamedValue. Can contain policy expressions. It may not be empty or consist
     * only of whitespace.
     * 
     * @param value the value value to set.
     * @return the NamedValueUpdateParameters object itself.
     */
    public NamedValueUpdateParameters withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueUpdateParameterProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Get the keyVault property: KeyVault location details of the namedValue.
     * 
     * @return the keyVault value.
     */
    public KeyVaultContractCreateProperties keyVault() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVault();
    }

    /**
     * Set the keyVault property: KeyVault location details of the namedValue.
     * 
     * @param keyVault the keyVault value to set.
     * @return the NamedValueUpdateParameters object itself.
     */
    public NamedValueUpdateParameters withKeyVault(KeyVaultContractCreateProperties keyVault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueUpdateParameterProperties();
        }
        this.innerProperties().withKeyVault(keyVault);
        return this;
    }

    /**
     * Get the tags property: Optional tags that when provided can be used to filter the NamedValue list.
     * 
     * @return the tags value.
     */
    public List<String> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    /**
     * Set the tags property: Optional tags that when provided can be used to filter the NamedValue list.
     * 
     * @param tags the tags value to set.
     * @return the NamedValueUpdateParameters object itself.
     */
    public NamedValueUpdateParameters withTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueUpdateParameterProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    /**
     * Get the secret property: Determines whether the value is a secret and should be encrypted or not. Default value
     * is false.
     * 
     * @return the secret value.
     */
    public Boolean secret() {
        return this.innerProperties() == null ? null : this.innerProperties().secret();
    }

    /**
     * Set the secret property: Determines whether the value is a secret and should be encrypted or not. Default value
     * is false.
     * 
     * @param secret the secret value to set.
     * @return the NamedValueUpdateParameters object itself.
     */
    public NamedValueUpdateParameters withSecret(Boolean secret) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamedValueUpdateParameterProperties();
        }
        this.innerProperties().withSecret(secret);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamedValueUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamedValueUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamedValueUpdateParameters.
     */
    public static NamedValueUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamedValueUpdateParameters deserializedNamedValueUpdateParameters = new NamedValueUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedNamedValueUpdateParameters.innerProperties
                        = NamedValueUpdateParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamedValueUpdateParameters;
        });
    }
}
