// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The format of the Operation Name for Application Insights telemetries. Default is Name.
 */
public final class OperationNameFormat extends ExpandableStringEnum<OperationNameFormat> {
    /**
     * Static value Name for OperationNameFormat.
     */
    public static final OperationNameFormat NAME = fromString("Name");

    /**
     * Static value Url for OperationNameFormat.
     */
    public static final OperationNameFormat URL = fromString("Url");

    /**
     * Creates a new instance of OperationNameFormat value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public OperationNameFormat() {
    }

    /**
     * Creates or finds a OperationNameFormat from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding OperationNameFormat.
     */
    public static OperationNameFormat fromString(String name) {
        return fromString(name, OperationNameFormat.class);
    }

    /**
     * Gets known OperationNameFormat values.
     * 
     * @return known OperationNameFormat values.
     */
    public static Collection<OperationNameFormat> values() {
        return values(OperationNameFormat.class);
    }
}
