// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * An immutable client-side representation of OperationResultContract.
 */
public interface OperationResultContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the idPropertiesId property: Operation result identifier.
     * 
     * @return the idPropertiesId value.
     */
    String idPropertiesId();

    /**
     * Gets the status property: Status of an async operation.
     * 
     * @return the status value.
     */
    AsyncOperationStatus status();

    /**
     * Gets the started property: Start time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the started value.
     */
    OffsetDateTime started();

    /**
     * Gets the updated property: Last update time of an async operation. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the updated value.
     */
    OffsetDateTime updated();

    /**
     * Gets the resultInfo property: Optional result info.
     * 
     * @return the resultInfo value.
     */
    String resultInfo();

    /**
     * Gets the error property: Error Body Contract.
     * 
     * @return the error value.
     */
    ErrorResponseBody error();

    /**
     * Gets the actionLog property: This property if only provided as part of the TenantConfiguration_Validate
     * operation. It contains the log the entities which will be updated/created/deleted as part of the
     * TenantConfiguration_Deploy operation.
     * 
     * @return the actionLog value.
     */
    List<OperationResultLogItemContract> actionLog();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.OperationResultContractInner object.
     * 
     * @return the inner object.
     */
    OperationResultContractInner innerModel();
}
