// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Log of the entity being created, updated or deleted.
 */
@Fluent
public final class OperationResultLogItemContract implements JsonSerializable<OperationResultLogItemContract> {
    /*
     * The type of entity contract.
     */
    private String objectType;

    /*
     * Action like create/update/delete.
     */
    private String action;

    /*
     * Identifier of the entity being created/updated/deleted.
     */
    private String objectKey;

    /**
     * Creates an instance of OperationResultLogItemContract class.
     */
    public OperationResultLogItemContract() {
    }

    /**
     * Get the objectType property: The type of entity contract.
     * 
     * @return the objectType value.
     */
    public String objectType() {
        return this.objectType;
    }

    /**
     * Set the objectType property: The type of entity contract.
     * 
     * @param objectType the objectType value to set.
     * @return the OperationResultLogItemContract object itself.
     */
    public OperationResultLogItemContract withObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    /**
     * Get the action property: Action like create/update/delete.
     * 
     * @return the action value.
     */
    public String action() {
        return this.action;
    }

    /**
     * Set the action property: Action like create/update/delete.
     * 
     * @param action the action value to set.
     * @return the OperationResultLogItemContract object itself.
     */
    public OperationResultLogItemContract withAction(String action) {
        this.action = action;
        return this;
    }

    /**
     * Get the objectKey property: Identifier of the entity being created/updated/deleted.
     * 
     * @return the objectKey value.
     */
    public String objectKey() {
        return this.objectKey;
    }

    /**
     * Set the objectKey property: Identifier of the entity being created/updated/deleted.
     * 
     * @param objectKey the objectKey value to set.
     * @return the OperationResultLogItemContract object itself.
     */
    public OperationResultLogItemContract withObjectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeStringField("objectKey", this.objectKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationResultLogItemContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationResultLogItemContract if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationResultLogItemContract.
     */
    public static OperationResultLogItemContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationResultLogItemContract deserializedOperationResultLogItemContract
                = new OperationResultLogItemContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("objectType".equals(fieldName)) {
                    deserializedOperationResultLogItemContract.objectType = reader.getString();
                } else if ("action".equals(fieldName)) {
                    deserializedOperationResultLogItemContract.action = reader.getString();
                } else if ("objectKey".equals(fieldName)) {
                    deserializedOperationResultLogItemContract.objectKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationResultLogItemContract;
        });
    }
}
