// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Endpoints accessed for a common purpose that the Api Management Service requires outbound network access to.
 */
@Fluent
public final class OutboundEnvironmentEndpoint implements JsonSerializable<OutboundEnvironmentEndpoint> {
    /*
     * The type of service accessed by the Api Management Service, e.g., Azure Storage, Azure SQL Database, and Azure
     * Active Directory.
     */
    private String category;

    /*
     * The endpoints that the Api Management Service reaches the service at.
     */
    private List<EndpointDependency> endpoints;

    /**
     * Creates an instance of OutboundEnvironmentEndpoint class.
     */
    public OutboundEnvironmentEndpoint() {
    }

    /**
     * Get the category property: The type of service accessed by the Api Management Service, e.g., Azure Storage, Azure
     * SQL Database, and Azure Active Directory.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: The type of service accessed by the Api Management Service, e.g., Azure Storage, Azure
     * SQL Database, and Azure Active Directory.
     * 
     * @param category the category value to set.
     * @return the OutboundEnvironmentEndpoint object itself.
     */
    public OutboundEnvironmentEndpoint withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the endpoints property: The endpoints that the Api Management Service reaches the service at.
     * 
     * @return the endpoints value.
     */
    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    /**
     * Set the endpoints property: The endpoints that the Api Management Service reaches the service at.
     * 
     * @param endpoints the endpoints value to set.
     * @return the OutboundEnvironmentEndpoint object itself.
     */
    public OutboundEnvironmentEndpoint withEndpoints(List<EndpointDependency> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpoints() != null) {
            endpoints().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OutboundEnvironmentEndpoint from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OutboundEnvironmentEndpoint if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OutboundEnvironmentEndpoint.
     */
    public static OutboundEnvironmentEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OutboundEnvironmentEndpoint deserializedOutboundEnvironmentEndpoint = new OutboundEnvironmentEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("category".equals(fieldName)) {
                    deserializedOutboundEnvironmentEndpoint.category = reader.getString();
                } else if ("endpoints".equals(fieldName)) {
                    List<EndpointDependency> endpoints
                        = reader.readArray(reader1 -> EndpointDependency.fromJson(reader1));
                    deserializedOutboundEnvironmentEndpoint.endpoints = endpoints;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOutboundEnvironmentEndpoint;
        });
    }
}
