// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Operation parameters details.
 */
@Fluent
public final class ParameterContract implements JsonSerializable<ParameterContract> {
    /*
     * Parameter name.
     */
    private String name;

    /*
     * Parameter description.
     */
    private String description;

    /*
     * Parameter type.
     */
    private String type;

    /*
     * Default parameter value.
     */
    private String defaultValue;

    /*
     * Specifies whether parameter is required or not.
     */
    private Boolean required;

    /*
     * Parameter values.
     */
    private List<String> values;

    /*
     * Schema identifier.
     */
    private String schemaId;

    /*
     * Type name defined by the schema.
     */
    private String typeName;

    /*
     * Exampled defined for the parameter.
     */
    private Map<String, ParameterExampleContract> examples;

    /**
     * Creates an instance of ParameterContract class.
     */
    public ParameterContract() {
    }

    /**
     * Get the name property: Parameter name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Parameter name.
     * 
     * @param name the name value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: Parameter description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Parameter description.
     * 
     * @param description the description value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the type property: Parameter type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Parameter type.
     * 
     * @param type the type value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the defaultValue property: Default parameter value.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: Default parameter value.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the required property: Specifies whether parameter is required or not.
     * 
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: Specifies whether parameter is required or not.
     * 
     * @param required the required value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Get the values property: Parameter values.
     * 
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values property: Parameter values.
     * 
     * @param values the values value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withValues(List<String> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the schemaId property: Schema identifier.
     * 
     * @return the schemaId value.
     */
    public String schemaId() {
        return this.schemaId;
    }

    /**
     * Set the schemaId property: Schema identifier.
     * 
     * @param schemaId the schemaId value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withSchemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    /**
     * Get the typeName property: Type name defined by the schema.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: Type name defined by the schema.
     * 
     * @param typeName the typeName value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the examples property: Exampled defined for the parameter.
     * 
     * @return the examples value.
     */
    public Map<String, ParameterExampleContract> examples() {
        return this.examples;
    }

    /**
     * Set the examples property: Exampled defined for the parameter.
     * 
     * @param examples the examples value to set.
     * @return the ParameterContract object itself.
     */
    public ParameterContract withExamples(Map<String, ParameterExampleContract> examples) {
        this.examples = examples;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model ParameterContract"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model ParameterContract"));
        }
        if (examples() != null) {
            examples().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ParameterContract.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("schemaId", this.schemaId);
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeMapField("examples", this.examples, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ParameterContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ParameterContract if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ParameterContract.
     */
    public static ParameterContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ParameterContract deserializedParameterContract = new ParameterContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedParameterContract.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedParameterContract.type = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedParameterContract.description = reader.getString();
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedParameterContract.defaultValue = reader.getString();
                } else if ("required".equals(fieldName)) {
                    deserializedParameterContract.required = reader.getNullable(JsonReader::getBoolean);
                } else if ("values".equals(fieldName)) {
                    List<String> values = reader.readArray(reader1 -> reader1.getString());
                    deserializedParameterContract.values = values;
                } else if ("schemaId".equals(fieldName)) {
                    deserializedParameterContract.schemaId = reader.getString();
                } else if ("typeName".equals(fieldName)) {
                    deserializedParameterContract.typeName = reader.getString();
                } else if ("examples".equals(fieldName)) {
                    Map<String, ParameterExampleContract> examples
                        = reader.readMap(reader1 -> ParameterExampleContract.fromJson(reader1));
                    deserializedParameterContract.examples = examples;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedParameterContract;
        });
    }
}
