// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameter example.
 */
@Fluent
public final class ParameterExampleContract implements JsonSerializable<ParameterExampleContract> {
    /*
     * Short description for the example
     */
    private String summary;

    /*
     * Long description for the example
     */
    private String description;

    /*
     * Example value. May be a primitive value, or an object.
     */
    private Object value;

    /*
     * A URL that points to the literal example
     */
    private String externalValue;

    /**
     * Creates an instance of ParameterExampleContract class.
     */
    public ParameterExampleContract() {
    }

    /**
     * Get the summary property: Short description for the example.
     * 
     * @return the summary value.
     */
    public String summary() {
        return this.summary;
    }

    /**
     * Set the summary property: Short description for the example.
     * 
     * @param summary the summary value to set.
     * @return the ParameterExampleContract object itself.
     */
    public ParameterExampleContract withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    /**
     * Get the description property: Long description for the example.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Long description for the example.
     * 
     * @param description the description value to set.
     * @return the ParameterExampleContract object itself.
     */
    public ParameterExampleContract withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the value property: Example value. May be a primitive value, or an object.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: Example value. May be a primitive value, or an object.
     * 
     * @param value the value value to set.
     * @return the ParameterExampleContract object itself.
     */
    public ParameterExampleContract withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the externalValue property: A URL that points to the literal example.
     * 
     * @return the externalValue value.
     */
    public String externalValue() {
        return this.externalValue;
    }

    /**
     * Set the externalValue property: A URL that points to the literal example.
     * 
     * @param externalValue the externalValue value to set.
     * @return the ParameterExampleContract object itself.
     */
    public ParameterExampleContract withExternalValue(String externalValue) {
        this.externalValue = externalValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("summary", this.summary);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("value", this.value);
        jsonWriter.writeStringField("externalValue", this.externalValue);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ParameterExampleContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ParameterExampleContract if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ParameterExampleContract.
     */
    public static ParameterExampleContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ParameterExampleContract deserializedParameterExampleContract = new ParameterExampleContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("summary".equals(fieldName)) {
                    deserializedParameterExampleContract.summary = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedParameterExampleContract.description = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedParameterExampleContract.value = reader.readUntyped();
                } else if ("externalValue".equals(fieldName)) {
                    deserializedParameterExampleContract.externalValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedParameterExampleContract;
        });
    }
}
