// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyDescriptionContractProperties;
import java.io.IOException;

/**
 * Policy description details.
 */
@Immutable
public final class PolicyDescriptionContract extends ProxyResource {
    /*
     * Policy description contract properties.
     */
    private PolicyDescriptionContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PolicyDescriptionContract class.
     */
    public PolicyDescriptionContract() {
    }

    /**
     * Get the innerProperties property: Policy description contract properties.
     * 
     * @return the innerProperties value.
     */
    private PolicyDescriptionContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: Policy description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the scope property: Binary OR value of the Snippet scope.
     * 
     * @return the scope value.
     */
    public Long scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyDescriptionContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyDescriptionContract if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicyDescriptionContract.
     */
    public static PolicyDescriptionContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyDescriptionContract deserializedPolicyDescriptionContract = new PolicyDescriptionContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPolicyDescriptionContract.innerProperties
                        = PolicyDescriptionContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyDescriptionContract;
        });
    }
}
