// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyRestrictionContractInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of the get policy restrictions operation.
 */
@Fluent
public final class PolicyRestrictionCollection implements JsonSerializable<PolicyRestrictionCollection> {
    /*
     * The value property.
     */
    private List<PolicyRestrictionContractInner> value;

    /*
     * Next page link if any.
     */
    private String nextLink;

    /**
     * Creates an instance of PolicyRestrictionCollection class.
     */
    public PolicyRestrictionCollection() {
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public List<PolicyRestrictionContractInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the PolicyRestrictionCollection object itself.
     */
    public PolicyRestrictionCollection withValue(List<PolicyRestrictionContractInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Next page link if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Next page link if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PolicyRestrictionCollection object itself.
     */
    public PolicyRestrictionCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyRestrictionCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyRestrictionCollection if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyRestrictionCollection.
     */
    public static PolicyRestrictionCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyRestrictionCollection deserializedPolicyRestrictionCollection = new PolicyRestrictionCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PolicyRestrictionContractInner> value
                        = reader.readArray(reader1 -> PolicyRestrictionContractInner.fromJson(reader1));
                    deserializedPolicyRestrictionCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPolicyRestrictionCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyRestrictionCollection;
        });
    }
}
