// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.PolicyRestrictionContractProperties;
import java.io.IOException;

/**
 * Policy restriction contract details.
 */
@Fluent
public final class PolicyRestrictionUpdateContract implements JsonSerializable<PolicyRestrictionUpdateContract> {
    /*
     * Properties of the Policy Restriction.
     */
    private PolicyRestrictionContractProperties innerProperties;

    /**
     * Creates an instance of PolicyRestrictionUpdateContract class.
     */
    public PolicyRestrictionUpdateContract() {
    }

    /**
     * Get the innerProperties property: Properties of the Policy Restriction.
     * 
     * @return the innerProperties value.
     */
    private PolicyRestrictionContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scope property: Path to the policy document.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: Path to the policy document.
     * 
     * @param scope the scope value to set.
     * @return the PolicyRestrictionUpdateContract object itself.
     */
    public PolicyRestrictionUpdateContract withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyRestrictionContractProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the requireBase property: Indicates if base policy should be enforced for the policy document.
     * 
     * @return the requireBase value.
     */
    public PolicyRestrictionRequireBase requireBase() {
        return this.innerProperties() == null ? null : this.innerProperties().requireBase();
    }

    /**
     * Set the requireBase property: Indicates if base policy should be enforced for the policy document.
     * 
     * @param requireBase the requireBase value to set.
     * @return the PolicyRestrictionUpdateContract object itself.
     */
    public PolicyRestrictionUpdateContract withRequireBase(PolicyRestrictionRequireBase requireBase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyRestrictionContractProperties();
        }
        this.innerProperties().withRequireBase(requireBase);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyRestrictionUpdateContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyRestrictionUpdateContract if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyRestrictionUpdateContract.
     */
    public static PolicyRestrictionUpdateContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyRestrictionUpdateContract deserializedPolicyRestrictionUpdateContract
                = new PolicyRestrictionUpdateContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedPolicyRestrictionUpdateContract.innerProperties
                        = PolicyRestrictionContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyRestrictionUpdateContract;
        });
    }
}
