// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of PolicyRestrictions.
 */
public interface PolicyRestrictions {
    /**
     * Gets all policy restrictions of API Management services.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all policy restrictions of API Management services as paginated response with {@link PagedIterable}.
     */
    PagedIterable<PolicyRestrictionContract> listByService(String resourceGroupName, String serviceName);

    /**
     * Gets all policy restrictions of API Management services.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all policy restrictions of API Management services as paginated response with {@link PagedIterable}.
     */
    PagedIterable<PolicyRestrictionContract> listByService(String resourceGroupName, String serviceName,
        Context context);

    /**
     * Gets the entity state (Etag) version of the policy restriction in the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the entity state (Etag) version of the policy restriction in the Api Management service.
     */
    PolicyRestrictionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String policyRestrictionId, Context context);

    /**
     * Gets the entity state (Etag) version of the policy restriction in the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void getEntityTag(String resourceGroupName, String serviceName, String policyRestrictionId);

    /**
     * Get the policy restriction of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy restriction of the Api Management service.
     */
    Response<PolicyRestrictionContract> getWithResponse(String resourceGroupName, String serviceName,
        String policyRestrictionId, Context context);

    /**
     * Get the policy restriction of the Api Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy restriction of the Api Management service.
     */
    PolicyRestrictionContract get(String resourceGroupName, String serviceName, String policyRestrictionId);

    /**
     * Deletes the policy restriction configuration of the Api Management Service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String policyRestrictionId,
        String ifMatch, Context context);

    /**
     * Deletes the policy restriction configuration of the Api Management Service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param policyRestrictionId Policy restrictions after an entity level.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String serviceName, String policyRestrictionId);

    /**
     * Get the policy restriction of the Api Management service.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy restriction of the Api Management service.
     */
    PolicyRestrictionContract getById(String id);

    /**
     * Get the policy restriction of the Api Management service.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy restriction of the Api Management service.
     */
    Response<PolicyRestrictionContract> getByIdWithResponse(String id, Context context);

    /**
     * Deletes the policy restriction configuration of the Api Management Service.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes the policy restriction configuration of the Api Management Service.
     * 
     * @param id the resource ID.
     * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an entity.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context);

    /**
     * Begins definition for a new PolicyRestrictionContract resource.
     * 
     * @param name resource name.
     * @return the first stage of the new PolicyRestrictionContract definition.
     */
    PolicyRestrictionContract.DefinitionStages.Blank define(String name);
}
