// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The developer portal Cross-Origin Resource Sharing (CORS) settings.
 */
@Fluent
public final class PortalConfigCorsProperties implements JsonSerializable<PortalConfigCorsProperties> {
    /*
     * Allowed origins, e.g. `https://trusted.com`.
     */
    private List<String> allowedOrigins;

    /**
     * Creates an instance of PortalConfigCorsProperties class.
     */
    public PortalConfigCorsProperties() {
    }

    /**
     * Get the allowedOrigins property: Allowed origins, e.g. `https://trusted.com`.
     * 
     * @return the allowedOrigins value.
     */
    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    /**
     * Set the allowedOrigins property: Allowed origins, e.g. `https://trusted.com`.
     * 
     * @param allowedOrigins the allowedOrigins value to set.
     * @return the PortalConfigCorsProperties object itself.
     */
    public PortalConfigCorsProperties withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedOrigins", this.allowedOrigins,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalConfigCorsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalConfigCorsProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalConfigCorsProperties.
     */
    public static PortalConfigCorsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalConfigCorsProperties deserializedPortalConfigCorsProperties = new PortalConfigCorsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedOrigins".equals(fieldName)) {
                    List<String> allowedOrigins = reader.readArray(reader1 -> reader1.getString());
                    deserializedPortalConfigCorsProperties.allowedOrigins = allowedOrigins;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalConfigCorsProperties;
        });
    }
}
