// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The PortalConfigDelegationProperties model.
 */
@Fluent
public final class PortalConfigDelegationProperties implements JsonSerializable<PortalConfigDelegationProperties> {
    /*
     * Enable or disable delegation for user registration.
     */
    private Boolean delegateRegistration;

    /*
     * Enable or disable delegation for product subscriptions.
     */
    private Boolean delegateSubscription;

    /*
     * A delegation endpoint URL.
     */
    private String delegationUrl;

    /*
     * A base64-encoded validation key to ensure requests originate from Azure API Management service.
     */
    private String validationKey;

    /**
     * Creates an instance of PortalConfigDelegationProperties class.
     */
    public PortalConfigDelegationProperties() {
    }

    /**
     * Get the delegateRegistration property: Enable or disable delegation for user registration.
     * 
     * @return the delegateRegistration value.
     */
    public Boolean delegateRegistration() {
        return this.delegateRegistration;
    }

    /**
     * Set the delegateRegistration property: Enable or disable delegation for user registration.
     * 
     * @param delegateRegistration the delegateRegistration value to set.
     * @return the PortalConfigDelegationProperties object itself.
     */
    public PortalConfigDelegationProperties withDelegateRegistration(Boolean delegateRegistration) {
        this.delegateRegistration = delegateRegistration;
        return this;
    }

    /**
     * Get the delegateSubscription property: Enable or disable delegation for product subscriptions.
     * 
     * @return the delegateSubscription value.
     */
    public Boolean delegateSubscription() {
        return this.delegateSubscription;
    }

    /**
     * Set the delegateSubscription property: Enable or disable delegation for product subscriptions.
     * 
     * @param delegateSubscription the delegateSubscription value to set.
     * @return the PortalConfigDelegationProperties object itself.
     */
    public PortalConfigDelegationProperties withDelegateSubscription(Boolean delegateSubscription) {
        this.delegateSubscription = delegateSubscription;
        return this;
    }

    /**
     * Get the delegationUrl property: A delegation endpoint URL.
     * 
     * @return the delegationUrl value.
     */
    public String delegationUrl() {
        return this.delegationUrl;
    }

    /**
     * Set the delegationUrl property: A delegation endpoint URL.
     * 
     * @param delegationUrl the delegationUrl value to set.
     * @return the PortalConfigDelegationProperties object itself.
     */
    public PortalConfigDelegationProperties withDelegationUrl(String delegationUrl) {
        this.delegationUrl = delegationUrl;
        return this;
    }

    /**
     * Get the validationKey property: A base64-encoded validation key to ensure requests originate from Azure API
     * Management service.
     * 
     * @return the validationKey value.
     */
    public String validationKey() {
        return this.validationKey;
    }

    /**
     * Set the validationKey property: A base64-encoded validation key to ensure requests originate from Azure API
     * Management service.
     * 
     * @param validationKey the validationKey value to set.
     * @return the PortalConfigDelegationProperties object itself.
     */
    public PortalConfigDelegationProperties withValidationKey(String validationKey) {
        this.validationKey = validationKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("delegateRegistration", this.delegateRegistration);
        jsonWriter.writeBooleanField("delegateSubscription", this.delegateSubscription);
        jsonWriter.writeStringField("delegationUrl", this.delegationUrl);
        jsonWriter.writeStringField("validationKey", this.validationKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalConfigDelegationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalConfigDelegationProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalConfigDelegationProperties.
     */
    public static PortalConfigDelegationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalConfigDelegationProperties deserializedPortalConfigDelegationProperties
                = new PortalConfigDelegationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("delegateRegistration".equals(fieldName)) {
                    deserializedPortalConfigDelegationProperties.delegateRegistration
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("delegateSubscription".equals(fieldName)) {
                    deserializedPortalConfigDelegationProperties.delegateSubscription
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("delegationUrl".equals(fieldName)) {
                    deserializedPortalConfigDelegationProperties.delegationUrl = reader.getString();
                } else if ("validationKey".equals(fieldName)) {
                    deserializedPortalConfigDelegationProperties.validationKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalConfigDelegationProperties;
        });
    }
}
