// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The PortalConfigPropertiesSignin model.
 */
@Fluent
public final class PortalConfigPropertiesSignin implements JsonSerializable<PortalConfigPropertiesSignin> {
    /*
     * Redirect anonymous users to the sign-in page.
     */
    private Boolean require;

    /**
     * Creates an instance of PortalConfigPropertiesSignin class.
     */
    public PortalConfigPropertiesSignin() {
    }

    /**
     * Get the require property: Redirect anonymous users to the sign-in page.
     * 
     * @return the require value.
     */
    public Boolean require() {
        return this.require;
    }

    /**
     * Set the require property: Redirect anonymous users to the sign-in page.
     * 
     * @param require the require value to set.
     * @return the PortalConfigPropertiesSignin object itself.
     */
    public PortalConfigPropertiesSignin withRequire(Boolean require) {
        this.require = require;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("require", this.require);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalConfigPropertiesSignin from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalConfigPropertiesSignin if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalConfigPropertiesSignin.
     */
    public static PortalConfigPropertiesSignin fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalConfigPropertiesSignin deserializedPortalConfigPropertiesSignin = new PortalConfigPropertiesSignin();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("require".equals(fieldName)) {
                    deserializedPortalConfigPropertiesSignin.require = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalConfigPropertiesSignin;
        });
    }
}
