// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The PortalConfigPropertiesSignup model.
 */
@Fluent
public final class PortalConfigPropertiesSignup implements JsonSerializable<PortalConfigPropertiesSignup> {
    /*
     * Terms of service settings.
     */
    private PortalConfigTermsOfServiceProperties termsOfService;

    /**
     * Creates an instance of PortalConfigPropertiesSignup class.
     */
    public PortalConfigPropertiesSignup() {
    }

    /**
     * Get the termsOfService property: Terms of service settings.
     * 
     * @return the termsOfService value.
     */
    public PortalConfigTermsOfServiceProperties termsOfService() {
        return this.termsOfService;
    }

    /**
     * Set the termsOfService property: Terms of service settings.
     * 
     * @param termsOfService the termsOfService value to set.
     * @return the PortalConfigPropertiesSignup object itself.
     */
    public PortalConfigPropertiesSignup withTermsOfService(PortalConfigTermsOfServiceProperties termsOfService) {
        this.termsOfService = termsOfService;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (termsOfService() != null) {
            termsOfService().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("termsOfService", this.termsOfService);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalConfigPropertiesSignup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalConfigPropertiesSignup if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PortalConfigPropertiesSignup.
     */
    public static PortalConfigPropertiesSignup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalConfigPropertiesSignup deserializedPortalConfigPropertiesSignup = new PortalConfigPropertiesSignup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("termsOfService".equals(fieldName)) {
                    deserializedPortalConfigPropertiesSignup.termsOfService
                        = PortalConfigTermsOfServiceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalConfigPropertiesSignup;
        });
    }
}
