// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.PortalDelegationSettingsInner;

/**
 * An immutable client-side representation of PortalDelegationSettings.
 */
public interface PortalDelegationSettings {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the url property: A delegation Url.
     * 
     * @return the url value.
     */
    String url();

    /**
     * Gets the validationKey property: A base64-encoded validation key to validate, that a request is coming from Azure
     * API Management.
     * 
     * @return the validationKey value.
     */
    String validationKey();

    /**
     * Gets the subscriptions property: Subscriptions delegation settings.
     * 
     * @return the subscriptions value.
     */
    SubscriptionsDelegationSettingsProperties subscriptions();

    /**
     * Gets the userRegistration property: User registration delegation settings.
     * 
     * @return the userRegistration value.
     */
    RegistrationDelegationSettingsProperties userRegistration();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.PortalDelegationSettingsInner object.
     * 
     * @return the inner object.
     */
    PortalDelegationSettingsInner innerModel();
}
