// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalRevisionContractInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of PortalRevisionContract.
 */
public interface PortalRevisionContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the description property: Portal revision description.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the statusDetails property: Portal revision publishing status details.
     * 
     * @return the statusDetails value.
     */
    String statusDetails();

    /**
     * Gets the status property: Status of the portal's revision.
     * 
     * @return the status value.
     */
    PortalRevisionStatus status();

    /**
     * Gets the isCurrent property: Indicates if the portal's revision is public.
     * 
     * @return the isCurrent value.
     */
    Boolean isCurrent();

    /**
     * Gets the createdDateTime property: Portal's revision creation date and time.
     * 
     * @return the createdDateTime value.
     */
    OffsetDateTime createdDateTime();

    /**
     * Gets the updatedDateTime property: Last updated date and time.
     * 
     * @return the updatedDateTime value.
     */
    OffsetDateTime updatedDateTime();

    /**
     * Gets the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    String provisioningState();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.PortalRevisionContractInner object.
     * 
     * @return the inner object.
     */
    PortalRevisionContractInner innerModel();

    /**
     * The entirety of the PortalRevisionContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The PortalRevisionContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the PortalRevisionContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the PortalRevisionContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @return the next definition stage.
             */
            WithCreate withExistingService(String resourceGroupName, String serviceName);
        }

        /**
         * The stage of the PortalRevisionContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithDescription, DefinitionStages.WithIsCurrent {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            PortalRevisionContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            PortalRevisionContract create(Context context);
        }

        /**
         * The stage of the PortalRevisionContract definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Portal revision description..
             * 
             * @param description Portal revision description.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the PortalRevisionContract definition allowing to specify isCurrent.
         */
        interface WithIsCurrent {
            /**
             * Specifies the isCurrent property: Indicates if the portal's revision is public..
             * 
             * @param isCurrent Indicates if the portal's revision is public.
             * @return the next definition stage.
             */
            WithCreate withIsCurrent(Boolean isCurrent);
        }
    }

    /**
     * Begins update for the PortalRevisionContract resource.
     * 
     * @return the stage of resource update.
     */
    PortalRevisionContract.Update update();

    /**
     * The template for PortalRevisionContract update.
     */
    interface Update extends UpdateStages.WithDescription, UpdateStages.WithIsCurrent, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        PortalRevisionContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        PortalRevisionContract apply(Context context);
    }

    /**
     * The PortalRevisionContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the PortalRevisionContract update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Portal revision description..
             * 
             * @param description Portal revision description.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the PortalRevisionContract update allowing to specify isCurrent.
         */
        interface WithIsCurrent {
            /**
             * Specifies the isCurrent property: Indicates if the portal's revision is public..
             * 
             * @param isCurrent Indicates if the portal's revision is public.
             * @return the next definition stage.
             */
            Update withIsCurrent(Boolean isCurrent);
        }

        /**
         * The stage of the PortalRevisionContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. ETag should match the current entity state from the
             * header response of the GET request or it should be * for unconditional update..
             * 
             * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of
             * the GET request or it should be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    PortalRevisionContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    PortalRevisionContract refresh(Context context);
}
