// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of PortalRevisions.
 */
public interface PortalRevisions {
    /**
     * Lists developer portal's revisions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged list of portal revisions as paginated response with {@link PagedIterable}.
     */
    PagedIterable<PortalRevisionContract> listByService(String resourceGroupName, String serviceName);

    /**
     * Lists developer portal's revisions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param filter | Field | Supported operators | Supported functions |
     * |-------------|------------------------|-----------------------------------|
     * 
     * |name | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith|
     * |description | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith|
     * |isCurrent | eq, ne | |.
     * @param top Number of records to return.
     * @param skip Number of records to skip.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged list of portal revisions as paginated response with {@link PagedIterable}.
     */
    PagedIterable<PortalRevisionContract> listByService(String resourceGroupName, String serviceName, String filter,
        Integer top, Integer skip, Context context);

    /**
     * Gets the developer portal revision specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param portalRevisionId Portal revision identifier. Must be unique in the current API Management service
     * instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the developer portal revision specified by its identifier.
     */
    PortalRevisionsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String portalRevisionId, Context context);

    /**
     * Gets the developer portal revision specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param portalRevisionId Portal revision identifier. Must be unique in the current API Management service
     * instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void getEntityTag(String resourceGroupName, String serviceName, String portalRevisionId);

    /**
     * Gets the developer portal's revision specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param portalRevisionId Portal revision identifier. Must be unique in the current API Management service
     * instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the developer portal's revision specified by its identifier.
     */
    Response<PortalRevisionContract> getWithResponse(String resourceGroupName, String serviceName,
        String portalRevisionId, Context context);

    /**
     * Gets the developer portal's revision specified by its identifier.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param portalRevisionId Portal revision identifier. Must be unique in the current API Management service
     * instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the developer portal's revision specified by its identifier.
     */
    PortalRevisionContract get(String resourceGroupName, String serviceName, String portalRevisionId);

    /**
     * Gets the developer portal's revision specified by its identifier.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the developer portal's revision specified by its identifier.
     */
    PortalRevisionContract getById(String id);

    /**
     * Gets the developer portal's revision specified by its identifier.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the developer portal's revision specified by its identifier.
     */
    Response<PortalRevisionContract> getByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new PortalRevisionContract resource.
     * 
     * @param name resource name.
     * @return the first stage of the new PortalRevisionContract definition.
     */
    PortalRevisionContract.DefinitionStages.Blank define(String name);
}
