// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.PortalSettingsContractProperties;
import java.io.IOException;

/**
 * Portal Settings for the Developer Portal.
 */
@Fluent
public final class PortalSettingsContract extends ProxyResource {
    /*
     * Portal Settings contract properties.
     */
    private PortalSettingsContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PortalSettingsContract class.
     */
    public PortalSettingsContract() {
    }

    /**
     * Get the innerProperties property: Portal Settings contract properties.
     * 
     * @return the innerProperties value.
     */
    private PortalSettingsContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the url property: A delegation Url.
     * 
     * @return the url value.
     */
    public String url() {
        return this.innerProperties() == null ? null : this.innerProperties().url();
    }

    /**
     * Set the url property: A delegation Url.
     * 
     * @param url the url value to set.
     * @return the PortalSettingsContract object itself.
     */
    public PortalSettingsContract withUrl(String url) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withUrl(url);
        return this;
    }

    /**
     * Get the validationKey property: A base64-encoded validation key to validate, that a request is coming from Azure
     * API Management.
     * 
     * @return the validationKey value.
     */
    public String validationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().validationKey();
    }

    /**
     * Set the validationKey property: A base64-encoded validation key to validate, that a request is coming from Azure
     * API Management.
     * 
     * @param validationKey the validationKey value to set.
     * @return the PortalSettingsContract object itself.
     */
    public PortalSettingsContract withValidationKey(String validationKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withValidationKey(validationKey);
        return this;
    }

    /**
     * Get the subscriptions property: Subscriptions delegation settings.
     * 
     * @return the subscriptions value.
     */
    public SubscriptionsDelegationSettingsProperties subscriptions() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptions();
    }

    /**
     * Set the subscriptions property: Subscriptions delegation settings.
     * 
     * @param subscriptions the subscriptions value to set.
     * @return the PortalSettingsContract object itself.
     */
    public PortalSettingsContract withSubscriptions(SubscriptionsDelegationSettingsProperties subscriptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withSubscriptions(subscriptions);
        return this;
    }

    /**
     * Get the userRegistration property: User registration delegation settings.
     * 
     * @return the userRegistration value.
     */
    public RegistrationDelegationSettingsProperties userRegistration() {
        return this.innerProperties() == null ? null : this.innerProperties().userRegistration();
    }

    /**
     * Set the userRegistration property: User registration delegation settings.
     * 
     * @param userRegistration the userRegistration value to set.
     * @return the PortalSettingsContract object itself.
     */
    public PortalSettingsContract withUserRegistration(RegistrationDelegationSettingsProperties userRegistration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withUserRegistration(userRegistration);
        return this;
    }

    /**
     * Get the enabled property: Redirect Anonymous users to the Sign-In page.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Redirect Anonymous users to the Sign-In page.
     * 
     * @param enabled the enabled value to set.
     * @return the PortalSettingsContract object itself.
     */
    public PortalSettingsContract withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the termsOfService property: Terms of service contract properties.
     * 
     * @return the termsOfService value.
     */
    public TermsOfServiceProperties termsOfService() {
        return this.innerProperties() == null ? null : this.innerProperties().termsOfService();
    }

    /**
     * Set the termsOfService property: Terms of service contract properties.
     * 
     * @param termsOfService the termsOfService value to set.
     * @return the PortalSettingsContract object itself.
     */
    public PortalSettingsContract withTermsOfService(TermsOfServiceProperties termsOfService) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PortalSettingsContractProperties();
        }
        this.innerProperties().withTermsOfService(termsOfService);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortalSettingsContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortalSettingsContract if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PortalSettingsContract.
     */
    public static PortalSettingsContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortalSettingsContract deserializedPortalSettingsContract = new PortalSettingsContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPortalSettingsContract.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPortalSettingsContract.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPortalSettingsContract.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPortalSettingsContract.innerProperties
                        = PortalSettingsContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortalSettingsContract;
        });
    }
}
