// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request to approve or reject a private endpoint connection.
 */
@Fluent
public final class PrivateEndpointConnectionRequest implements JsonSerializable<PrivateEndpointConnectionRequest> {
    /*
     * Private Endpoint Connection Resource Id.
     */
    private String id;

    /*
     * The connection state of the private endpoint connection.
     */
    private PrivateEndpointConnectionRequestProperties properties;

    /**
     * Creates an instance of PrivateEndpointConnectionRequest class.
     */
    public PrivateEndpointConnectionRequest() {
    }

    /**
     * Get the id property: Private Endpoint Connection Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Private Endpoint Connection Resource Id.
     * 
     * @param id the id value to set.
     * @return the PrivateEndpointConnectionRequest object itself.
     */
    public PrivateEndpointConnectionRequest withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the properties property: The connection state of the private endpoint connection.
     * 
     * @return the properties value.
     */
    public PrivateEndpointConnectionRequestProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The connection state of the private endpoint connection.
     * 
     * @param properties the properties value to set.
     * @return the PrivateEndpointConnectionRequest object itself.
     */
    public PrivateEndpointConnectionRequest withProperties(PrivateEndpointConnectionRequestProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateEndpointConnectionRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateEndpointConnectionRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateEndpointConnectionRequest.
     */
    public static PrivateEndpointConnectionRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateEndpointConnectionRequest deserializedPrivateEndpointConnectionRequest
                = new PrivateEndpointConnectionRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionRequest.id = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionRequest.properties
                        = PrivateEndpointConnectionRequestProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateEndpointConnectionRequest;
        });
    }
}
