// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;

/**
 * An immutable client-side representation of ProductApiLinkContract.
 */
public interface ProductApiLinkContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the apiId property: Full resource Id of an API.
     * 
     * @return the apiId value.
     */
    String apiId();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner object.
     * 
     * @return the inner object.
     */
    ProductApiLinkContractInner innerModel();

    /**
     * The entirety of the ProductApiLinkContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The ProductApiLinkContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the ProductApiLinkContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the ProductApiLinkContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, productId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param productId Product identifier. Must be unique in the current API Management service instance.
             * @return the next definition stage.
             */
            WithCreate withExistingProduct(String resourceGroupName, String serviceName, String productId);
        }

        /**
         * The stage of the ProductApiLinkContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithApiId {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            ProductApiLinkContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            ProductApiLinkContract create(Context context);
        }

        /**
         * The stage of the ProductApiLinkContract definition allowing to specify apiId.
         */
        interface WithApiId {
            /**
             * Specifies the apiId property: Full resource Id of an API..
             * 
             * @param apiId Full resource Id of an API.
             * @return the next definition stage.
             */
            WithCreate withApiId(String apiId);
        }
    }

    /**
     * Begins update for the ProductApiLinkContract resource.
     * 
     * @return the stage of resource update.
     */
    ProductApiLinkContract.Update update();

    /**
     * The template for ProductApiLinkContract update.
     */
    interface Update extends UpdateStages.WithApiId {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        ProductApiLinkContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        ProductApiLinkContract apply(Context context);
    }

    /**
     * The ProductApiLinkContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the ProductApiLinkContract update allowing to specify apiId.
         */
        interface WithApiId {
            /**
             * Specifies the apiId property: Full resource Id of an API..
             * 
             * @param apiId Full resource Id of an API.
             * @return the next definition stage.
             */
            Update withApiId(String apiId);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    ProductApiLinkContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    ProductApiLinkContract refresh(Context context);
}
