// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductContractInner;

/**
 * An immutable client-side representation of ProductContract.
 */
public interface ProductContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the displayName property: Product name.
     * 
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the description property: Product description. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the terms property: Product terms of use. Developers trying to subscribe to the product will be presented
     * and required to accept these terms before they can complete the subscription process.
     * 
     * @return the terms value.
     */
    String terms();

    /**
     * Gets the subscriptionRequired property: Whether a product subscription is required for accessing APIs included in
     * this product. If true, the product is referred to as "protected" and a valid subscription key is required for a
     * request to an API included in the product to succeed. If false, the product is referred to as "open" and requests
     * to an API included in the product can be made without a subscription key. If property is omitted when creating a
     * new product it's value is assumed to be true.
     * 
     * @return the subscriptionRequired value.
     */
    Boolean subscriptionRequired();

    /**
     * Gets the approvalRequired property: whether subscription approval is required. If false, new subscriptions will
     * be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true,
     * administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be
     * present only if subscriptionRequired property is present and has a value of false.
     * 
     * @return the approvalRequired value.
     */
    Boolean approvalRequired();

    /**
     * Gets the subscriptionsLimit property: Whether the number of subscriptions a user can have to this product at the
     * same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if
     * subscriptionRequired property is present and has a value of false.
     * 
     * @return the subscriptionsLimit value.
     */
    Integer subscriptionsLimit();

    /**
     * Gets the state property: whether product is published or not. Published products are discoverable by users of
     * developer portal. Non published products are visible only to administrators. Default state of Product is
     * notPublished.
     * 
     * @return the state value.
     */
    ProductState state();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ProductContractInner object.
     * 
     * @return the inner object.
     */
    ProductContractInner innerModel();

    /**
     * The entirety of the ProductContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The ProductContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the ProductContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the ProductContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @return the next definition stage.
             */
            WithCreate withExistingService(String resourceGroupName, String serviceName);
        }

        /**
         * The stage of the ProductContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithDisplayName, DefinitionStages.WithDescription, DefinitionStages.WithTerms,
            DefinitionStages.WithSubscriptionRequired, DefinitionStages.WithApprovalRequired,
            DefinitionStages.WithSubscriptionsLimit, DefinitionStages.WithState, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            ProductContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            ProductContract create(Context context);
        }

        /**
         * The stage of the ProductContract definition allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Product name..
             * 
             * @param displayName Product name.
             * @return the next definition stage.
             */
            WithCreate withDisplayName(String displayName);
        }

        /**
         * The stage of the ProductContract definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Product description. May include HTML formatting tags..
             * 
             * @param description Product description. May include HTML formatting tags.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the ProductContract definition allowing to specify terms.
         */
        interface WithTerms {
            /**
             * Specifies the terms property: Product terms of use. Developers trying to subscribe to the product will be
             * presented and required to accept these terms before they can complete the subscription process..
             * 
             * @param terms Product terms of use. Developers trying to subscribe to the product will be presented and
             * required to accept these terms before they can complete the subscription process.
             * @return the next definition stage.
             */
            WithCreate withTerms(String terms);
        }

        /**
         * The stage of the ProductContract definition allowing to specify subscriptionRequired.
         */
        interface WithSubscriptionRequired {
            /**
             * Specifies the subscriptionRequired property: Whether a product subscription is required for accessing
             * APIs included in this product. If true, the product is referred to as "protected" and a valid
             * subscription key is required for a request to an API included in the product to succeed. If false, the
             * product is referred to as "open" and requests to an API included in the product can be made without a
             * subscription key. If property is omitted when creating a new product it's value is assumed to be true..
             * 
             * @param subscriptionRequired Whether a product subscription is required for accessing APIs included in
             * this product. If true, the product is referred to as "protected" and a valid subscription key is required
             * for a request to an API included in the product to succeed. If false, the product is referred to as
             * "open" and requests to an API included in the product can be made without a subscription key. If property
             * is omitted when creating a new product it's value is assumed to be true.
             * @return the next definition stage.
             */
            WithCreate withSubscriptionRequired(Boolean subscriptionRequired);
        }

        /**
         * The stage of the ProductContract definition allowing to specify approvalRequired.
         */
        interface WithApprovalRequired {
            /**
             * Specifies the approvalRequired property: whether subscription approval is required. If false, new
             * subscriptions will be approved automatically enabling developers to call the product’s APIs immediately
             * after subscribing. If true, administrators must manually approve the subscription before the developer
             * can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a
             * value of false..
             * 
             * @param approvalRequired whether subscription approval is required. If false, new subscriptions will be
             * approved automatically enabling developers to call the product’s APIs immediately after subscribing. If
             * true, administrators must manually approve the subscription before the developer can any of the product’s
             * APIs. Can be present only if subscriptionRequired property is present and has a value of false.
             * @return the next definition stage.
             */
            WithCreate withApprovalRequired(Boolean approvalRequired);
        }

        /**
         * The stage of the ProductContract definition allowing to specify subscriptionsLimit.
         */
        interface WithSubscriptionsLimit {
            /**
             * Specifies the subscriptionsLimit property: Whether the number of subscriptions a user can have to this
             * product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
             * only if subscriptionRequired property is present and has a value of false..
             * 
             * @param subscriptionsLimit Whether the number of subscriptions a user can have to this product at the same
             * time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if
             * subscriptionRequired property is present and has a value of false.
             * @return the next definition stage.
             */
            WithCreate withSubscriptionsLimit(Integer subscriptionsLimit);
        }

        /**
         * The stage of the ProductContract definition allowing to specify state.
         */
        interface WithState {
            /**
             * Specifies the state property: whether product is published or not. Published products are discoverable by
             * users of developer portal. Non published products are visible only to administrators. Default state of
             * Product is notPublished..
             * 
             * @param state whether product is published or not. Published products are discoverable by users of
             * developer portal. Non published products are visible only to administrators. Default state of Product is
             * notPublished.
             * @return the next definition stage.
             */
            WithCreate withState(ProductState state);
        }

        /**
         * The stage of the ProductContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the ProductContract resource.
     * 
     * @return the stage of resource update.
     */
    ProductContract.Update update();

    /**
     * The template for ProductContract update.
     */
    interface Update extends UpdateStages.WithDisplayName, UpdateStages.WithDescription, UpdateStages.WithTerms,
        UpdateStages.WithSubscriptionRequired, UpdateStages.WithApprovalRequired, UpdateStages.WithSubscriptionsLimit,
        UpdateStages.WithState, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        ProductContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        ProductContract apply(Context context);
    }

    /**
     * The ProductContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the ProductContract update allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Product name..
             * 
             * @param displayName Product name.
             * @return the next definition stage.
             */
            Update withDisplayName(String displayName);
        }

        /**
         * The stage of the ProductContract update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Product description. May include HTML formatting tags..
             * 
             * @param description Product description. May include HTML formatting tags.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the ProductContract update allowing to specify terms.
         */
        interface WithTerms {
            /**
             * Specifies the terms property: Product terms of use. Developers trying to subscribe to the product will be
             * presented and required to accept these terms before they can complete the subscription process..
             * 
             * @param terms Product terms of use. Developers trying to subscribe to the product will be presented and
             * required to accept these terms before they can complete the subscription process.
             * @return the next definition stage.
             */
            Update withTerms(String terms);
        }

        /**
         * The stage of the ProductContract update allowing to specify subscriptionRequired.
         */
        interface WithSubscriptionRequired {
            /**
             * Specifies the subscriptionRequired property: Whether a product subscription is required for accessing
             * APIs included in this product. If true, the product is referred to as "protected" and a valid
             * subscription key is required for a request to an API included in the product to succeed. If false, the
             * product is referred to as "open" and requests to an API included in the product can be made without a
             * subscription key. If property is omitted when creating a new product it's value is assumed to be true..
             * 
             * @param subscriptionRequired Whether a product subscription is required for accessing APIs included in
             * this product. If true, the product is referred to as "protected" and a valid subscription key is required
             * for a request to an API included in the product to succeed. If false, the product is referred to as
             * "open" and requests to an API included in the product can be made without a subscription key. If property
             * is omitted when creating a new product it's value is assumed to be true.
             * @return the next definition stage.
             */
            Update withSubscriptionRequired(Boolean subscriptionRequired);
        }

        /**
         * The stage of the ProductContract update allowing to specify approvalRequired.
         */
        interface WithApprovalRequired {
            /**
             * Specifies the approvalRequired property: whether subscription approval is required. If false, new
             * subscriptions will be approved automatically enabling developers to call the product’s APIs immediately
             * after subscribing. If true, administrators must manually approve the subscription before the developer
             * can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a
             * value of false..
             * 
             * @param approvalRequired whether subscription approval is required. If false, new subscriptions will be
             * approved automatically enabling developers to call the product’s APIs immediately after subscribing. If
             * true, administrators must manually approve the subscription before the developer can any of the product’s
             * APIs. Can be present only if subscriptionRequired property is present and has a value of false.
             * @return the next definition stage.
             */
            Update withApprovalRequired(Boolean approvalRequired);
        }

        /**
         * The stage of the ProductContract update allowing to specify subscriptionsLimit.
         */
        interface WithSubscriptionsLimit {
            /**
             * Specifies the subscriptionsLimit property: Whether the number of subscriptions a user can have to this
             * product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
             * only if subscriptionRequired property is present and has a value of false..
             * 
             * @param subscriptionsLimit Whether the number of subscriptions a user can have to this product at the same
             * time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if
             * subscriptionRequired property is present and has a value of false.
             * @return the next definition stage.
             */
            Update withSubscriptionsLimit(Integer subscriptionsLimit);
        }

        /**
         * The stage of the ProductContract update allowing to specify state.
         */
        interface WithState {
            /**
             * Specifies the state property: whether product is published or not. Published products are discoverable by
             * users of developer portal. Non published products are visible only to administrators. Default state of
             * Product is notPublished..
             * 
             * @param state whether product is published or not. Published products are discoverable by users of
             * developer portal. Non published products are visible only to administrators. Default state of Product is
             * notPublished.
             * @return the next definition stage.
             */
            Update withState(ProductState state);
        }

        /**
         * The stage of the ProductContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. ETag should match the current entity state from the
             * header response of the GET request or it should be * for unconditional update..
             * 
             * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of
             * the GET request or it should be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    ProductContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    ProductContract refresh(Context context);
}
