// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Product Entity Base Parameters.
 */
@Fluent
public class ProductEntityBaseParameters implements JsonSerializable<ProductEntityBaseParameters> {
    /*
     * Product description. May include HTML formatting tags.
     */
    private String description;

    /*
     * Product terms of use. Developers trying to subscribe to the product will be presented and required to accept
     * these terms before they can complete the subscription process.
     */
    private String terms;

    /*
     * Whether a product subscription is required for accessing APIs included in this product. If true, the product is
     * referred to as "protected" and a valid subscription key is required for a request to an API included in the
     * product to succeed. If false, the product is referred to as "open" and requests to an API included in the product
     * can be made without a subscription key. If property is omitted when creating a new product it's value is assumed
     * to be true.
     */
    private Boolean subscriptionRequired;

    /*
     * whether subscription approval is required. If false, new subscriptions will be approved automatically enabling
     * developers to call the product’s APIs immediately after subscribing. If true, administrators must manually
     * approve the subscription before the developer can any of the product’s APIs. Can be present only if
     * subscriptionRequired property is present and has a value of false.
     */
    private Boolean approvalRequired;

    /*
     * Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to
     * allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a
     * value of false.
     */
    private Integer subscriptionsLimit;

    /*
     * whether product is published or not. Published products are discoverable by users of developer portal. Non
     * published products are visible only to administrators. Default state of Product is notPublished.
     */
    private ProductState state;

    /**
     * Creates an instance of ProductEntityBaseParameters class.
     */
    public ProductEntityBaseParameters() {
    }

    /**
     * Get the description property: Product description. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Product description. May include HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the ProductEntityBaseParameters object itself.
     */
    public ProductEntityBaseParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the terms property: Product terms of use. Developers trying to subscribe to the product will be presented and
     * required to accept these terms before they can complete the subscription process.
     * 
     * @return the terms value.
     */
    public String terms() {
        return this.terms;
    }

    /**
     * Set the terms property: Product terms of use. Developers trying to subscribe to the product will be presented and
     * required to accept these terms before they can complete the subscription process.
     * 
     * @param terms the terms value to set.
     * @return the ProductEntityBaseParameters object itself.
     */
    public ProductEntityBaseParameters withTerms(String terms) {
        this.terms = terms;
        return this;
    }

    /**
     * Get the subscriptionRequired property: Whether a product subscription is required for accessing APIs included in
     * this product. If true, the product is referred to as "protected" and a valid subscription key is required for a
     * request to an API included in the product to succeed. If false, the product is referred to as "open" and requests
     * to an API included in the product can be made without a subscription key. If property is omitted when creating a
     * new product it's value is assumed to be true.
     * 
     * @return the subscriptionRequired value.
     */
    public Boolean subscriptionRequired() {
        return this.subscriptionRequired;
    }

    /**
     * Set the subscriptionRequired property: Whether a product subscription is required for accessing APIs included in
     * this product. If true, the product is referred to as "protected" and a valid subscription key is required for a
     * request to an API included in the product to succeed. If false, the product is referred to as "open" and requests
     * to an API included in the product can be made without a subscription key. If property is omitted when creating a
     * new product it's value is assumed to be true.
     * 
     * @param subscriptionRequired the subscriptionRequired value to set.
     * @return the ProductEntityBaseParameters object itself.
     */
    public ProductEntityBaseParameters withSubscriptionRequired(Boolean subscriptionRequired) {
        this.subscriptionRequired = subscriptionRequired;
        return this;
    }

    /**
     * Get the approvalRequired property: whether subscription approval is required. If false, new subscriptions will be
     * approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true,
     * administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be
     * present only if subscriptionRequired property is present and has a value of false.
     * 
     * @return the approvalRequired value.
     */
    public Boolean approvalRequired() {
        return this.approvalRequired;
    }

    /**
     * Set the approvalRequired property: whether subscription approval is required. If false, new subscriptions will be
     * approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true,
     * administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be
     * present only if subscriptionRequired property is present and has a value of false.
     * 
     * @param approvalRequired the approvalRequired value to set.
     * @return the ProductEntityBaseParameters object itself.
     */
    public ProductEntityBaseParameters withApprovalRequired(Boolean approvalRequired) {
        this.approvalRequired = approvalRequired;
        return this;
    }

    /**
     * Get the subscriptionsLimit property: Whether the number of subscriptions a user can have to this product at the
     * same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if
     * subscriptionRequired property is present and has a value of false.
     * 
     * @return the subscriptionsLimit value.
     */
    public Integer subscriptionsLimit() {
        return this.subscriptionsLimit;
    }

    /**
     * Set the subscriptionsLimit property: Whether the number of subscriptions a user can have to this product at the
     * same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if
     * subscriptionRequired property is present and has a value of false.
     * 
     * @param subscriptionsLimit the subscriptionsLimit value to set.
     * @return the ProductEntityBaseParameters object itself.
     */
    public ProductEntityBaseParameters withSubscriptionsLimit(Integer subscriptionsLimit) {
        this.subscriptionsLimit = subscriptionsLimit;
        return this;
    }

    /**
     * Get the state property: whether product is published or not. Published products are discoverable by users of
     * developer portal. Non published products are visible only to administrators. Default state of Product is
     * notPublished.
     * 
     * @return the state value.
     */
    public ProductState state() {
        return this.state;
    }

    /**
     * Set the state property: whether product is published or not. Published products are discoverable by users of
     * developer portal. Non published products are visible only to administrators. Default state of Product is
     * notPublished.
     * 
     * @param state the state value to set.
     * @return the ProductEntityBaseParameters object itself.
     */
    public ProductEntityBaseParameters withState(ProductState state) {
        this.state = state;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("terms", this.terms);
        jsonWriter.writeBooleanField("subscriptionRequired", this.subscriptionRequired);
        jsonWriter.writeBooleanField("approvalRequired", this.approvalRequired);
        jsonWriter.writeNumberField("subscriptionsLimit", this.subscriptionsLimit);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProductEntityBaseParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProductEntityBaseParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProductEntityBaseParameters.
     */
    public static ProductEntityBaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProductEntityBaseParameters deserializedProductEntityBaseParameters = new ProductEntityBaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.description = reader.getString();
                } else if ("terms".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.terms = reader.getString();
                } else if ("subscriptionRequired".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.subscriptionRequired
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("approvalRequired".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.approvalRequired
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("subscriptionsLimit".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.subscriptionsLimit = reader.getNullable(JsonReader::getInt);
                } else if ("state".equals(fieldName)) {
                    deserializedProductEntityBaseParameters.state = ProductState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProductEntityBaseParameters;
        });
    }
}
