// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;
import java.io.IOException;
import java.util.List;

/**
 * Paged Product-group link list representation.
 */
@Fluent
public final class ProductGroupLinkCollection implements JsonSerializable<ProductGroupLinkCollection> {
    /*
     * Page values.
     */
    private List<ProductGroupLinkContractInner> value;

    /*
     * Total record count number across all pages.
     */
    private Long count;

    /*
     * Next page link if any.
     */
    private String nextLink;

    /**
     * Creates an instance of ProductGroupLinkCollection class.
     */
    public ProductGroupLinkCollection() {
    }

    /**
     * Get the value property: Page values.
     * 
     * @return the value value.
     */
    public List<ProductGroupLinkContractInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Page values.
     * 
     * @param value the value value to set.
     * @return the ProductGroupLinkCollection object itself.
     */
    public ProductGroupLinkCollection withValue(List<ProductGroupLinkContractInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the count property: Total record count number across all pages.
     * 
     * @return the count value.
     */
    public Long count() {
        return this.count;
    }

    /**
     * Set the count property: Total record count number across all pages.
     * 
     * @param count the count value to set.
     * @return the ProductGroupLinkCollection object itself.
     */
    public ProductGroupLinkCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the nextLink property: Next page link if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Next page link if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ProductGroupLinkCollection object itself.
     */
    public ProductGroupLinkCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProductGroupLinkCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProductGroupLinkCollection if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProductGroupLinkCollection.
     */
    public static ProductGroupLinkCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProductGroupLinkCollection deserializedProductGroupLinkCollection = new ProductGroupLinkCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ProductGroupLinkContractInner> value
                        = reader.readArray(reader1 -> ProductGroupLinkContractInner.fromJson(reader1));
                    deserializedProductGroupLinkCollection.value = value;
                } else if ("count".equals(fieldName)) {
                    deserializedProductGroupLinkCollection.count = reader.getNullable(JsonReader::getLong);
                } else if ("nextLink".equals(fieldName)) {
                    deserializedProductGroupLinkCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProductGroupLinkCollection;
        });
    }
}
