// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;

/**
 * An immutable client-side representation of ProductGroupLinkContract.
 */
public interface ProductGroupLinkContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the groupId property: Full resource Id of a group.
     * 
     * @return the groupId value.
     */
    String groupId();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner object.
     * 
     * @return the inner object.
     */
    ProductGroupLinkContractInner innerModel();

    /**
     * The entirety of the ProductGroupLinkContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The ProductGroupLinkContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the ProductGroupLinkContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the ProductGroupLinkContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, productId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param productId Product identifier. Must be unique in the current API Management service instance.
             * @return the next definition stage.
             */
            WithCreate withExistingProduct(String resourceGroupName, String serviceName, String productId);
        }

        /**
         * The stage of the ProductGroupLinkContract definition which contains all the minimum required properties for
         * the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithGroupId {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            ProductGroupLinkContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            ProductGroupLinkContract create(Context context);
        }

        /**
         * The stage of the ProductGroupLinkContract definition allowing to specify groupId.
         */
        interface WithGroupId {
            /**
             * Specifies the groupId property: Full resource Id of a group..
             * 
             * @param groupId Full resource Id of a group.
             * @return the next definition stage.
             */
            WithCreate withGroupId(String groupId);
        }
    }

    /**
     * Begins update for the ProductGroupLinkContract resource.
     * 
     * @return the stage of resource update.
     */
    ProductGroupLinkContract.Update update();

    /**
     * The template for ProductGroupLinkContract update.
     */
    interface Update extends UpdateStages.WithGroupId {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        ProductGroupLinkContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        ProductGroupLinkContract apply(Context context);
    }

    /**
     * The ProductGroupLinkContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the ProductGroupLinkContract update allowing to specify groupId.
         */
        interface WithGroupId {
            /**
             * Specifies the groupId property: Full resource Id of a group..
             * 
             * @param groupId Full resource Id of a group.
             * @return the next definition stage.
             */
            Update withGroupId(String groupId);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    ProductGroupLinkContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    ProductGroupLinkContract refresh(Context context);
}
