// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

/**
 * whether product is published or not. Published products are discoverable by users of developer portal. Non published
 * products are visible only to administrators. Default state of Product is notPublished.
 */
public enum ProductState {
    /**
     * Enum value notPublished.
     */
    NOT_PUBLISHED("notPublished"),

    /**
     * Enum value published.
     */
    PUBLISHED("published");

    /**
     * The actual serialized value for a ProductState instance.
     */
    private final String value;

    ProductState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ProductState instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ProductState object, or null if unable to parse.
     */
    public static ProductState fromString(String value) {
        if (value == null) {
            return null;
        }
        ProductState[] items = ProductState.values();
        for (ProductState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
