// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductUpdateProperties;
import java.io.IOException;

/**
 * Product Update parameters.
 */
@Fluent
public final class ProductUpdateParameters implements JsonSerializable<ProductUpdateParameters> {
    /*
     * Product entity Update contract properties.
     */
    private ProductUpdateProperties innerProperties;

    /**
     * Creates an instance of ProductUpdateParameters class.
     */
    public ProductUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Product entity Update contract properties.
     * 
     * @return the innerProperties value.
     */
    private ProductUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the displayName property: Product name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Product name.
     * 
     * @param displayName the displayName value to set.
     * @return the ProductUpdateParameters object itself.
     */
    public ProductUpdateParameters withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductUpdateProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: Product description. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Product description. May include HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the ProductUpdateParameters object itself.
     */
    public ProductUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the terms property: Product terms of use. Developers trying to subscribe to the product will be presented and
     * required to accept these terms before they can complete the subscription process.
     * 
     * @return the terms value.
     */
    public String terms() {
        return this.innerProperties() == null ? null : this.innerProperties().terms();
    }

    /**
     * Set the terms property: Product terms of use. Developers trying to subscribe to the product will be presented and
     * required to accept these terms before they can complete the subscription process.
     * 
     * @param terms the terms value to set.
     * @return the ProductUpdateParameters object itself.
     */
    public ProductUpdateParameters withTerms(String terms) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductUpdateProperties();
        }
        this.innerProperties().withTerms(terms);
        return this;
    }

    /**
     * Get the subscriptionRequired property: Whether a product subscription is required for accessing APIs included in
     * this product. If true, the product is referred to as "protected" and a valid subscription key is required for a
     * request to an API included in the product to succeed. If false, the product is referred to as "open" and requests
     * to an API included in the product can be made without a subscription key. If property is omitted when creating a
     * new product it's value is assumed to be true.
     * 
     * @return the subscriptionRequired value.
     */
    public Boolean subscriptionRequired() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionRequired();
    }

    /**
     * Set the subscriptionRequired property: Whether a product subscription is required for accessing APIs included in
     * this product. If true, the product is referred to as "protected" and a valid subscription key is required for a
     * request to an API included in the product to succeed. If false, the product is referred to as "open" and requests
     * to an API included in the product can be made without a subscription key. If property is omitted when creating a
     * new product it's value is assumed to be true.
     * 
     * @param subscriptionRequired the subscriptionRequired value to set.
     * @return the ProductUpdateParameters object itself.
     */
    public ProductUpdateParameters withSubscriptionRequired(Boolean subscriptionRequired) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductUpdateProperties();
        }
        this.innerProperties().withSubscriptionRequired(subscriptionRequired);
        return this;
    }

    /**
     * Get the approvalRequired property: whether subscription approval is required. If false, new subscriptions will be
     * approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true,
     * administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be
     * present only if subscriptionRequired property is present and has a value of false.
     * 
     * @return the approvalRequired value.
     */
    public Boolean approvalRequired() {
        return this.innerProperties() == null ? null : this.innerProperties().approvalRequired();
    }

    /**
     * Set the approvalRequired property: whether subscription approval is required. If false, new subscriptions will be
     * approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true,
     * administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be
     * present only if subscriptionRequired property is present and has a value of false.
     * 
     * @param approvalRequired the approvalRequired value to set.
     * @return the ProductUpdateParameters object itself.
     */
    public ProductUpdateParameters withApprovalRequired(Boolean approvalRequired) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductUpdateProperties();
        }
        this.innerProperties().withApprovalRequired(approvalRequired);
        return this;
    }

    /**
     * Get the subscriptionsLimit property: Whether the number of subscriptions a user can have to this product at the
     * same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if
     * subscriptionRequired property is present and has a value of false.
     * 
     * @return the subscriptionsLimit value.
     */
    public Integer subscriptionsLimit() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionsLimit();
    }

    /**
     * Set the subscriptionsLimit property: Whether the number of subscriptions a user can have to this product at the
     * same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if
     * subscriptionRequired property is present and has a value of false.
     * 
     * @param subscriptionsLimit the subscriptionsLimit value to set.
     * @return the ProductUpdateParameters object itself.
     */
    public ProductUpdateParameters withSubscriptionsLimit(Integer subscriptionsLimit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductUpdateProperties();
        }
        this.innerProperties().withSubscriptionsLimit(subscriptionsLimit);
        return this;
    }

    /**
     * Get the state property: whether product is published or not. Published products are discoverable by users of
     * developer portal. Non published products are visible only to administrators. Default state of Product is
     * notPublished.
     * 
     * @return the state value.
     */
    public ProductState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: whether product is published or not. Published products are discoverable by users of
     * developer portal. Non published products are visible only to administrators. Default state of Product is
     * notPublished.
     * 
     * @param state the state value to set.
     * @return the ProductUpdateParameters object itself.
     */
    public ProductUpdateParameters withState(ProductState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProductUpdateProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProductUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProductUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProductUpdateParameters.
     */
    public static ProductUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProductUpdateParameters deserializedProductUpdateParameters = new ProductUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedProductUpdateParameters.innerProperties = ProductUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProductUpdateParameters;
        });
    }
}
