// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * User registration delegation settings properties.
 */
@Fluent
public final class RegistrationDelegationSettingsProperties
    implements JsonSerializable<RegistrationDelegationSettingsProperties> {
    /*
     * Enable or disable delegation for user registration.
     */
    private Boolean enabled;

    /**
     * Creates an instance of RegistrationDelegationSettingsProperties class.
     */
    public RegistrationDelegationSettingsProperties() {
    }

    /**
     * Get the enabled property: Enable or disable delegation for user registration.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Enable or disable delegation for user registration.
     * 
     * @param enabled the enabled value to set.
     * @return the RegistrationDelegationSettingsProperties object itself.
     */
    public RegistrationDelegationSettingsProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegistrationDelegationSettingsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegistrationDelegationSettingsProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegistrationDelegationSettingsProperties.
     */
    public static RegistrationDelegationSettingsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegistrationDelegationSettingsProperties deserializedRegistrationDelegationSettingsProperties
                = new RegistrationDelegationSettingsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedRegistrationDelegationSettingsProperties.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegistrationDelegationSettingsProperties;
        });
    }
}
