// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.ReportRecordContractInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of ReportRecordContract.
 */
public interface ReportRecordContract {
    /**
     * Gets the name property: Name depending on report endpoint specifies product, API, operation or developer name.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the timestamp property: Start of aggregation period. The date conforms to the following format:
     * `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the timestamp value.
     */
    OffsetDateTime timestamp();

    /**
     * Gets the interval property: Length of aggregation period. Interval must be multiple of 15 minutes and may not be
     * zero. The value should be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
     * 
     * @return the interval value.
     */
    String interval();

    /**
     * Gets the country property: Country to which this record data is related.
     * 
     * @return the country value.
     */
    String country();

    /**
     * Gets the region property: Country region to which this record data is related.
     * 
     * @return the region value.
     */
    String region();

    /**
     * Gets the zip property: Zip code to which this record data is related.
     * 
     * @return the zip value.
     */
    String zip();

    /**
     * Gets the userId property: User identifier path. /users/{userId}.
     * 
     * @return the userId value.
     */
    String userId();

    /**
     * Gets the productId property: Product identifier path. /products/{productId}.
     * 
     * @return the productId value.
     */
    String productId();

    /**
     * Gets the apiId property: API identifier path. /apis/{apiId}.
     * 
     * @return the apiId value.
     */
    String apiId();

    /**
     * Gets the operationId property: Operation identifier path. /apis/{apiId}/operations/{operationId}.
     * 
     * @return the operationId value.
     */
    String operationId();

    /**
     * Gets the apiRegion property: API region identifier.
     * 
     * @return the apiRegion value.
     */
    String apiRegion();

    /**
     * Gets the subscriptionId property: Subscription identifier path. /subscriptions/{subscriptionId}.
     * 
     * @return the subscriptionId value.
     */
    String subscriptionId();

    /**
     * Gets the callCountSuccess property: Number of successful calls. This includes calls returning HttpStatusCode
     * &lt;= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect.
     * 
     * @return the callCountSuccess value.
     */
    Integer callCountSuccess();

    /**
     * Gets the callCountBlocked property: Number of calls blocked due to invalid credentials. This includes calls
     * returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and HttpStatusCode.TooManyRequests.
     * 
     * @return the callCountBlocked value.
     */
    Integer callCountBlocked();

    /**
     * Gets the callCountFailed property: Number of calls failed due to gateway or backend errors. This includes calls
     * returning HttpStatusCode.BadRequest(400) and any Code between HttpStatusCode.InternalServerError (500) and 600.
     * 
     * @return the callCountFailed value.
     */
    Integer callCountFailed();

    /**
     * Gets the callCountOther property: Number of other calls.
     * 
     * @return the callCountOther value.
     */
    Integer callCountOther();

    /**
     * Gets the callCountTotal property: Total number of calls.
     * 
     * @return the callCountTotal value.
     */
    Integer callCountTotal();

    /**
     * Gets the bandwidth property: Bandwidth consumed.
     * 
     * @return the bandwidth value.
     */
    Long bandwidth();

    /**
     * Gets the cacheHitCount property: Number of times when content was served from cache policy.
     * 
     * @return the cacheHitCount value.
     */
    Integer cacheHitCount();

    /**
     * Gets the cacheMissCount property: Number of times content was fetched from backend.
     * 
     * @return the cacheMissCount value.
     */
    Integer cacheMissCount();

    /**
     * Gets the apiTimeAvg property: Average time it took to process request.
     * 
     * @return the apiTimeAvg value.
     */
    Double apiTimeAvg();

    /**
     * Gets the apiTimeMin property: Minimum time it took to process request.
     * 
     * @return the apiTimeMin value.
     */
    Double apiTimeMin();

    /**
     * Gets the apiTimeMax property: Maximum time it took to process request.
     * 
     * @return the apiTimeMax value.
     */
    Double apiTimeMax();

    /**
     * Gets the serviceTimeAvg property: Average time it took to process request on backend.
     * 
     * @return the serviceTimeAvg value.
     */
    Double serviceTimeAvg();

    /**
     * Gets the serviceTimeMin property: Minimum time it took to process request on backend.
     * 
     * @return the serviceTimeMin value.
     */
    Double serviceTimeMin();

    /**
     * Gets the serviceTimeMax property: Maximum time it took to process request on backend.
     * 
     * @return the serviceTimeMax value.
     */
    Double serviceTimeMax();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ReportRecordContractInner object.
     * 
     * @return the inner object.
     */
    ReportRecordContractInner innerModel();
}
