// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Operation request/response representation details.
 */
@Fluent
public final class RepresentationContract implements JsonSerializable<RepresentationContract> {
    /*
     * Specifies a registered or custom content type for this representation, e.g. application/xml.
     */
    private String contentType;

    /*
     * Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor
     * 'multipart/form-data'.
     */
    private String schemaId;

    /*
     * Type name defined by the schema. Applicable only if 'contentType' value is neither
     * 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     */
    private String typeName;

    /*
     * Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or
     * 'multipart/form-data'..
     */
    private List<ParameterContract> formParameters;

    /*
     * Exampled defined for the representation.
     */
    private Map<String, ParameterExampleContract> examples;

    /**
     * Creates an instance of RepresentationContract class.
     */
    public RepresentationContract() {
    }

    /**
     * Get the contentType property: Specifies a registered or custom content type for this representation, e.g.
     * application/xml.
     * 
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Specifies a registered or custom content type for this representation, e.g.
     * application/xml.
     * 
     * @param contentType the contentType value to set.
     * @return the RepresentationContract object itself.
     */
    public RepresentationContract withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the schemaId property: Schema identifier. Applicable only if 'contentType' value is neither
     * 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     * 
     * @return the schemaId value.
     */
    public String schemaId() {
        return this.schemaId;
    }

    /**
     * Set the schemaId property: Schema identifier. Applicable only if 'contentType' value is neither
     * 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     * 
     * @param schemaId the schemaId value to set.
     * @return the RepresentationContract object itself.
     */
    public RepresentationContract withSchemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    /**
     * Get the typeName property: Type name defined by the schema. Applicable only if 'contentType' value is neither
     * 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: Type name defined by the schema. Applicable only if 'contentType' value is neither
     * 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
     * 
     * @param typeName the typeName value to set.
     * @return the RepresentationContract object itself.
     */
    public RepresentationContract withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the formParameters property: Collection of form parameters. Required if 'contentType' value is either
     * 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     * 
     * @return the formParameters value.
     */
    public List<ParameterContract> formParameters() {
        return this.formParameters;
    }

    /**
     * Set the formParameters property: Collection of form parameters. Required if 'contentType' value is either
     * 'application/x-www-form-urlencoded' or 'multipart/form-data'..
     * 
     * @param formParameters the formParameters value to set.
     * @return the RepresentationContract object itself.
     */
    public RepresentationContract withFormParameters(List<ParameterContract> formParameters) {
        this.formParameters = formParameters;
        return this;
    }

    /**
     * Get the examples property: Exampled defined for the representation.
     * 
     * @return the examples value.
     */
    public Map<String, ParameterExampleContract> examples() {
        return this.examples;
    }

    /**
     * Set the examples property: Exampled defined for the representation.
     * 
     * @param examples the examples value to set.
     * @return the RepresentationContract object itself.
     */
    public RepresentationContract withExamples(Map<String, ParameterExampleContract> examples) {
        this.examples = examples;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (contentType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property contentType in model RepresentationContract"));
        }
        if (formParameters() != null) {
            formParameters().forEach(e -> e.validate());
        }
        if (examples() != null) {
            examples().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RepresentationContract.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("schemaId", this.schemaId);
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeArrayField("formParameters", this.formParameters,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("examples", this.examples, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RepresentationContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RepresentationContract if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RepresentationContract.
     */
    public static RepresentationContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RepresentationContract deserializedRepresentationContract = new RepresentationContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentType".equals(fieldName)) {
                    deserializedRepresentationContract.contentType = reader.getString();
                } else if ("schemaId".equals(fieldName)) {
                    deserializedRepresentationContract.schemaId = reader.getString();
                } else if ("typeName".equals(fieldName)) {
                    deserializedRepresentationContract.typeName = reader.getString();
                } else if ("formParameters".equals(fieldName)) {
                    List<ParameterContract> formParameters
                        = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    deserializedRepresentationContract.formParameters = formParameters;
                } else if ("examples".equals(fieldName)) {
                    Map<String, ParameterExampleContract> examples
                        = reader.readMap(reader1 -> ParameterExampleContract.fromJson(reader1));
                    deserializedRepresentationContract.examples = examples;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRepresentationContract;
        });
    }
}
