// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.RequestReportRecordContractInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of RequestReportRecordContract.
 */
public interface RequestReportRecordContract {
    /**
     * Gets the apiId property: API identifier path. /apis/{apiId}.
     * 
     * @return the apiId value.
     */
    String apiId();

    /**
     * Gets the operationId property: Operation identifier path. /apis/{apiId}/operations/{operationId}.
     * 
     * @return the operationId value.
     */
    String operationId();

    /**
     * Gets the productId property: Product identifier path. /products/{productId}.
     * 
     * @return the productId value.
     */
    String productId();

    /**
     * Gets the userId property: User identifier path. /users/{userId}.
     * 
     * @return the userId value.
     */
    String userId();

    /**
     * Gets the method property: The HTTP method associated with this request..
     * 
     * @return the method value.
     */
    String method();

    /**
     * Gets the url property: The full URL associated with this request.
     * 
     * @return the url value.
     */
    String url();

    /**
     * Gets the ipAddress property: The client IP address associated with this request.
     * 
     * @return the ipAddress value.
     */
    String ipAddress();

    /**
     * Gets the backendResponseCode property: The HTTP status code received by the gateway as a result of forwarding
     * this request to the backend.
     * 
     * @return the backendResponseCode value.
     */
    String backendResponseCode();

    /**
     * Gets the responseCode property: The HTTP status code returned by the gateway.
     * 
     * @return the responseCode value.
     */
    Integer responseCode();

    /**
     * Gets the responseSize property: The size of the response returned by the gateway.
     * 
     * @return the responseSize value.
     */
    Integer responseSize();

    /**
     * Gets the timestamp property: The date and time when this request was received by the gateway in ISO 8601 format.
     * 
     * @return the timestamp value.
     */
    OffsetDateTime timestamp();

    /**
     * Gets the cache property: Specifies if response cache was involved in generating the response. If the value is
     * none, the cache was not used. If the value is hit, cached response was returned. If the value is miss, the cache
     * was used but lookup resulted in a miss and request was fulfilled by the backend.
     * 
     * @return the cache value.
     */
    String cache();

    /**
     * Gets the apiTime property: The total time it took to process this request.
     * 
     * @return the apiTime value.
     */
    Double apiTime();

    /**
     * Gets the serviceTime property: he time it took to forward this request to the backend and get the response back.
     * 
     * @return the serviceTime value.
     */
    Double serviceTime();

    /**
     * Gets the apiRegion property: Azure region where the gateway that processed this request is located.
     * 
     * @return the apiRegion value.
     */
    String apiRegion();

    /**
     * Gets the subscriptionId property: Subscription identifier path. /subscriptions/{subscriptionId}.
     * 
     * @return the subscriptionId value.
     */
    String subscriptionId();

    /**
     * Gets the requestId property: Request Identifier.
     * 
     * @return the requestId value.
     */
    String requestId();

    /**
     * Gets the requestSize property: The size of this request..
     * 
     * @return the requestSize value.
     */
    Integer requestSize();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.RequestReportRecordContractInner object.
     * 
     * @return the inner object.
     */
    RequestReportRecordContractInner innerModel();
}
