// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ResolverContractInner;

/**
 * An immutable client-side representation of ResolverContract.
 */
public interface ResolverContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the displayName property: Resolver Name.
     * 
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the path property: Path is type/field being resolved.
     * 
     * @return the path value.
     */
    String path();

    /**
     * Gets the description property: Description of the resolver. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ResolverContractInner object.
     * 
     * @return the inner object.
     */
    ResolverContractInner innerModel();

    /**
     * The entirety of the ResolverContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The ResolverContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the ResolverContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the ResolverContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, apiId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param apiId API revision identifier. Must be unique in the current API Management service instance.
             * Non-current revision has ;rev=n as a suffix where n is the revision number.
             * @return the next definition stage.
             */
            WithCreate withExistingApi(String resourceGroupName, String serviceName, String apiId);
        }

        /**
         * The stage of the ResolverContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithDisplayName, DefinitionStages.WithPath,
            DefinitionStages.WithDescription, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            ResolverContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            ResolverContract create(Context context);
        }

        /**
         * The stage of the ResolverContract definition allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Resolver Name..
             * 
             * @param displayName Resolver Name.
             * @return the next definition stage.
             */
            WithCreate withDisplayName(String displayName);
        }

        /**
         * The stage of the ResolverContract definition allowing to specify path.
         */
        interface WithPath {
            /**
             * Specifies the path property: Path is type/field being resolved..
             * 
             * @param path Path is type/field being resolved.
             * @return the next definition stage.
             */
            WithCreate withPath(String path);
        }

        /**
         * The stage of the ResolverContract definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description of the resolver. May include HTML formatting tags..
             * 
             * @param description Description of the resolver. May include HTML formatting tags.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the ResolverContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the ResolverContract resource.
     * 
     * @return the stage of resource update.
     */
    ResolverContract.Update update();

    /**
     * The template for ResolverContract update.
     */
    interface Update extends UpdateStages.WithDisplayName, UpdateStages.WithPath, UpdateStages.WithDescription,
        UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        ResolverContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        ResolverContract apply(Context context);
    }

    /**
     * The ResolverContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the ResolverContract update allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Resolver Name..
             * 
             * @param displayName Resolver Name.
             * @return the next definition stage.
             */
            Update withDisplayName(String displayName);
        }

        /**
         * The stage of the ResolverContract update allowing to specify path.
         */
        interface WithPath {
            /**
             * Specifies the path property: Path is type/field being resolved..
             * 
             * @param path Path is type/field being resolved.
             * @return the next definition stage.
             */
            Update withPath(String path);
        }

        /**
         * The stage of the ResolverContract update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description of the resolver. May include HTML formatting tags..
             * 
             * @param description Description of the resolver. May include HTML formatting tags.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the ResolverContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. ETag should match the current entity state from the
             * header response of the GET request or it should be * for unconditional update..
             * 
             * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of
             * the GET request or it should be * for unconditional update.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    ResolverContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    ResolverContract refresh(Context context);
}
