// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ResolverUpdateContractProperties;
import java.io.IOException;

/**
 * GraphQL API Resolver Update Contract details.
 */
@Fluent
public final class ResolverUpdateContract implements JsonSerializable<ResolverUpdateContract> {
    /*
     * Properties of the GraphQL API Resolver entity that can be updated.
     */
    private ResolverUpdateContractProperties innerProperties;

    /**
     * Creates an instance of ResolverUpdateContract class.
     */
    public ResolverUpdateContract() {
    }

    /**
     * Get the innerProperties property: Properties of the GraphQL API Resolver entity that can be updated.
     * 
     * @return the innerProperties value.
     */
    private ResolverUpdateContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the displayName property: Resolver Name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Resolver Name.
     * 
     * @param displayName the displayName value to set.
     * @return the ResolverUpdateContract object itself.
     */
    public ResolverUpdateContract withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResolverUpdateContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the path property: Path is type/field being resolved.
     * 
     * @return the path value.
     */
    public String path() {
        return this.innerProperties() == null ? null : this.innerProperties().path();
    }

    /**
     * Set the path property: Path is type/field being resolved.
     * 
     * @param path the path value to set.
     * @return the ResolverUpdateContract object itself.
     */
    public ResolverUpdateContract withPath(String path) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResolverUpdateContractProperties();
        }
        this.innerProperties().withPath(path);
        return this;
    }

    /**
     * Get the description property: Description of the resolver. May include HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the resolver. May include HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the ResolverUpdateContract object itself.
     */
    public ResolverUpdateContract withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ResolverUpdateContractProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResolverUpdateContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResolverUpdateContract if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResolverUpdateContract.
     */
    public static ResolverUpdateContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResolverUpdateContract deserializedResolverUpdateContract = new ResolverUpdateContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedResolverUpdateContract.innerProperties
                        = ResolverUpdateContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResolverUpdateContract;
        });
    }
}
