// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource location data properties.
 */
@Fluent
public final class ResourceLocationDataContract implements JsonSerializable<ResourceLocationDataContract> {
    /*
     * A canonical name for the geographic or physical location.
     */
    private String name;

    /*
     * The city or locality where the resource is located.
     */
    private String city;

    /*
     * The district, state, or province where the resource is located.
     */
    private String district;

    /*
     * The country or region where the resource is located.
     */
    private String countryOrRegion;

    /**
     * Creates an instance of ResourceLocationDataContract class.
     */
    public ResourceLocationDataContract() {
    }

    /**
     * Get the name property: A canonical name for the geographic or physical location.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A canonical name for the geographic or physical location.
     * 
     * @param name the name value to set.
     * @return the ResourceLocationDataContract object itself.
     */
    public ResourceLocationDataContract withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the city property: The city or locality where the resource is located.
     * 
     * @return the city value.
     */
    public String city() {
        return this.city;
    }

    /**
     * Set the city property: The city or locality where the resource is located.
     * 
     * @param city the city value to set.
     * @return the ResourceLocationDataContract object itself.
     */
    public ResourceLocationDataContract withCity(String city) {
        this.city = city;
        return this;
    }

    /**
     * Get the district property: The district, state, or province where the resource is located.
     * 
     * @return the district value.
     */
    public String district() {
        return this.district;
    }

    /**
     * Set the district property: The district, state, or province where the resource is located.
     * 
     * @param district the district value to set.
     * @return the ResourceLocationDataContract object itself.
     */
    public ResourceLocationDataContract withDistrict(String district) {
        this.district = district;
        return this;
    }

    /**
     * Get the countryOrRegion property: The country or region where the resource is located.
     * 
     * @return the countryOrRegion value.
     */
    public String countryOrRegion() {
        return this.countryOrRegion;
    }

    /**
     * Set the countryOrRegion property: The country or region where the resource is located.
     * 
     * @param countryOrRegion the countryOrRegion value to set.
     * @return the ResourceLocationDataContract object itself.
     */
    public ResourceLocationDataContract withCountryOrRegion(String countryOrRegion) {
        this.countryOrRegion = countryOrRegion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model ResourceLocationDataContract"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ResourceLocationDataContract.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("district", this.district);
        jsonWriter.writeStringField("countryOrRegion", this.countryOrRegion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceLocationDataContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceLocationDataContract if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceLocationDataContract.
     */
    public static ResourceLocationDataContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceLocationDataContract deserializedResourceLocationDataContract = new ResourceLocationDataContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedResourceLocationDataContract.name = reader.getString();
                } else if ("city".equals(fieldName)) {
                    deserializedResourceLocationDataContract.city = reader.getString();
                } else if ("district".equals(fieldName)) {
                    deserializedResourceLocationDataContract.district = reader.getString();
                } else if ("countryOrRegion".equals(fieldName)) {
                    deserializedResourceLocationDataContract.countryOrRegion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceLocationDataContract;
        });
    }
}
