// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes an available API Management SKU.
 */
@Fluent
public final class ResourceSku implements JsonSerializable<ResourceSku> {
    /*
     * Name of the Sku.
     */
    private SkuType name;

    /**
     * Creates an instance of ResourceSku class.
     */
    public ResourceSku() {
    }

    /**
     * Get the name property: Name of the Sku.
     * 
     * @return the name value.
     */
    public SkuType name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Sku.
     * 
     * @param name the name value to set.
     * @return the ResourceSku object itself.
     */
    public ResourceSku withName(SkuType name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceSku.
     */
    public static ResourceSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSku deserializedResourceSku = new ResourceSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedResourceSku.name = SkuType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSku;
        });
    }
}
