// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The scale type applicable to the sku.
 */
public final class ResourceSkuCapacityScaleType extends ExpandableStringEnum<ResourceSkuCapacityScaleType> {
    /**
     * Static value automatic for ResourceSkuCapacityScaleType.
     */
    public static final ResourceSkuCapacityScaleType AUTOMATIC = fromString("automatic");

    /**
     * Static value manual for ResourceSkuCapacityScaleType.
     */
    public static final ResourceSkuCapacityScaleType MANUAL = fromString("manual");

    /**
     * Static value none for ResourceSkuCapacityScaleType.
     */
    public static final ResourceSkuCapacityScaleType NONE = fromString("none");

    /**
     * Creates a new instance of ResourceSkuCapacityScaleType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ResourceSkuCapacityScaleType() {
    }

    /**
     * Creates or finds a ResourceSkuCapacityScaleType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ResourceSkuCapacityScaleType.
     */
    public static ResourceSkuCapacityScaleType fromString(String name) {
        return fromString(name, ResourceSkuCapacityScaleType.class);
    }

    /**
     * Gets known ResourceSkuCapacityScaleType values.
     * 
     * @return known ResourceSkuCapacityScaleType values.
     */
    public static Collection<ResourceSkuCapacityScaleType> values() {
        return values(ResourceSkuCapacityScaleType.class);
    }
}
