// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ResourceSkuResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The API Management service SKUs operation response.
 */
@Fluent
public final class ResourceSkuResults implements JsonSerializable<ResourceSkuResults> {
    /*
     * The list of skus available for the service.
     */
    private List<ResourceSkuResultInner> value;

    /*
     * The uri to fetch the next page of API Management service Skus.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceSkuResults class.
     */
    public ResourceSkuResults() {
    }

    /**
     * Get the value property: The list of skus available for the service.
     * 
     * @return the value value.
     */
    public List<ResourceSkuResultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of skus available for the service.
     * 
     * @param value the value value to set.
     * @return the ResourceSkuResults object itself.
     */
    public ResourceSkuResults withValue(List<ResourceSkuResultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of API Management service Skus.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of API Management service Skus.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ResourceSkuResults object itself.
     */
    public ResourceSkuResults withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model ResourceSkuResults"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ResourceSkuResults.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceSkuResults from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceSkuResults if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceSkuResults.
     */
    public static ResourceSkuResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceSkuResults deserializedResourceSkuResults = new ResourceSkuResults();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ResourceSkuResultInner> value
                        = reader.readArray(reader1 -> ResourceSkuResultInner.fromJson(reader1));
                    deserializedResourceSkuResults.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceSkuResults.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceSkuResults;
        });
    }
}
