// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Operation response details.
 */
@Fluent
public final class ResponseContract implements JsonSerializable<ResponseContract> {
    /*
     * Operation response HTTP status code.
     */
    private int statusCode;

    /*
     * Operation response description.
     */
    private String description;

    /*
     * Collection of operation response representations.
     */
    private List<RepresentationContract> representations;

    /*
     * Collection of operation response headers.
     */
    private List<ParameterContract> headers;

    /**
     * Creates an instance of ResponseContract class.
     */
    public ResponseContract() {
    }

    /**
     * Get the statusCode property: Operation response HTTP status code.
     * 
     * @return the statusCode value.
     */
    public int statusCode() {
        return this.statusCode;
    }

    /**
     * Set the statusCode property: Operation response HTTP status code.
     * 
     * @param statusCode the statusCode value to set.
     * @return the ResponseContract object itself.
     */
    public ResponseContract withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Get the description property: Operation response description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Operation response description.
     * 
     * @param description the description value to set.
     * @return the ResponseContract object itself.
     */
    public ResponseContract withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the representations property: Collection of operation response representations.
     * 
     * @return the representations value.
     */
    public List<RepresentationContract> representations() {
        return this.representations;
    }

    /**
     * Set the representations property: Collection of operation response representations.
     * 
     * @param representations the representations value to set.
     * @return the ResponseContract object itself.
     */
    public ResponseContract withRepresentations(List<RepresentationContract> representations) {
        this.representations = representations;
        return this;
    }

    /**
     * Get the headers property: Collection of operation response headers.
     * 
     * @return the headers value.
     */
    public List<ParameterContract> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: Collection of operation response headers.
     * 
     * @param headers the headers value to set.
     * @return the ResponseContract object itself.
     */
    public ResponseContract withHeaders(List<ParameterContract> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (representations() != null) {
            representations().forEach(e -> e.validate());
        }
        if (headers() != null) {
            headers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("statusCode", this.statusCode);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("representations", this.representations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponseContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponseContract if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponseContract.
     */
    public static ResponseContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponseContract deserializedResponseContract = new ResponseContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("statusCode".equals(fieldName)) {
                    deserializedResponseContract.statusCode = reader.getInt();
                } else if ("description".equals(fieldName)) {
                    deserializedResponseContract.description = reader.getString();
                } else if ("representations".equals(fieldName)) {
                    List<RepresentationContract> representations
                        = reader.readArray(reader1 -> RepresentationContract.fromJson(reader1));
                    deserializedResponseContract.representations = representations;
                } else if ("headers".equals(fieldName)) {
                    List<ParameterContract> headers = reader.readArray(reader1 -> ParameterContract.fromJson(reader1));
                    deserializedResponseContract.headers = headers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResponseContract;
        });
    }
}
