// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.SaveConfigurationParameterProperties;
import java.io.IOException;

/**
 * Save Tenant Configuration Contract details.
 */
@Fluent
public final class SaveConfigurationParameter implements JsonSerializable<SaveConfigurationParameter> {
    /*
     * Properties of the Save Configuration Parameters.
     */
    private SaveConfigurationParameterProperties innerProperties;

    /**
     * Creates an instance of SaveConfigurationParameter class.
     */
    public SaveConfigurationParameter() {
    }

    /**
     * Get the innerProperties property: Properties of the Save Configuration Parameters.
     * 
     * @return the innerProperties value.
     */
    private SaveConfigurationParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the branch property: The name of the Git branch in which to commit the current configuration snapshot.
     * 
     * @return the branch value.
     */
    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    /**
     * Set the branch property: The name of the Git branch in which to commit the current configuration snapshot.
     * 
     * @param branch the branch value to set.
     * @return the SaveConfigurationParameter object itself.
     */
    public SaveConfigurationParameter withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SaveConfigurationParameterProperties();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    /**
     * Get the force property: The value if true, the current configuration database is committed to the Git repository,
     * even if the Git repository has newer changes that would be overwritten.
     * 
     * @return the force value.
     */
    public Boolean force() {
        return this.innerProperties() == null ? null : this.innerProperties().force();
    }

    /**
     * Set the force property: The value if true, the current configuration database is committed to the Git repository,
     * even if the Git repository has newer changes that would be overwritten.
     * 
     * @param force the force value to set.
     * @return the SaveConfigurationParameter object itself.
     */
    public SaveConfigurationParameter withForce(Boolean force) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SaveConfigurationParameterProperties();
        }
        this.innerProperties().withForce(force);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SaveConfigurationParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SaveConfigurationParameter if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SaveConfigurationParameter.
     */
    public static SaveConfigurationParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SaveConfigurationParameter deserializedSaveConfigurationParameter = new SaveConfigurationParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedSaveConfigurationParameter.innerProperties
                        = SaveConfigurationParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSaveConfigurationParameter;
        });
    }
}
