// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.SchemaContractInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of the list schema operation.
 */
@Fluent
public final class SchemaCollection implements JsonSerializable<SchemaCollection> {
    /*
     * API Schema Contract value.
     */
    private List<SchemaContractInner> value;

    /*
     * Total record count number.
     */
    private Long count;

    /*
     * Next page link if any.
     */
    private String nextLink;

    /**
     * Creates an instance of SchemaCollection class.
     */
    public SchemaCollection() {
    }

    /**
     * Get the value property: API Schema Contract value.
     * 
     * @return the value value.
     */
    public List<SchemaContractInner> value() {
        return this.value;
    }

    /**
     * Get the count property: Total record count number.
     * 
     * @return the count value.
     */
    public Long count() {
        return this.count;
    }

    /**
     * Set the count property: Total record count number.
     * 
     * @param count the count value to set.
     * @return the SchemaCollection object itself.
     */
    public SchemaCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the nextLink property: Next page link if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SchemaCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SchemaCollection if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SchemaCollection.
     */
    public static SchemaCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SchemaCollection deserializedSchemaCollection = new SchemaCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SchemaContractInner> value
                        = reader.readArray(reader1 -> SchemaContractInner.fromJson(reader1));
                    deserializedSchemaCollection.value = value;
                } else if ("count".equals(fieldName)) {
                    deserializedSchemaCollection.count = reader.getNullable(JsonReader::getLong);
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSchemaCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSchemaCollection;
        });
    }
}
