// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Name of the Sku.
 */
public final class SkuType extends ExpandableStringEnum<SkuType> {
    /**
     * Static value Developer for SkuType.
     */
    public static final SkuType DEVELOPER = fromString("Developer");

    /**
     * Static value Standard for SkuType.
     */
    public static final SkuType STANDARD = fromString("Standard");

    /**
     * Static value Premium for SkuType.
     */
    public static final SkuType PREMIUM = fromString("Premium");

    /**
     * Static value Basic for SkuType.
     */
    public static final SkuType BASIC = fromString("Basic");

    /**
     * Static value Consumption for SkuType.
     */
    public static final SkuType CONSUMPTION = fromString("Consumption");

    /**
     * Static value Isolated for SkuType.
     */
    public static final SkuType ISOLATED = fromString("Isolated");

    /**
     * Static value BasicV2 for SkuType.
     */
    public static final SkuType BASIC_V2 = fromString("BasicV2");

    /**
     * Static value StandardV2 for SkuType.
     */
    public static final SkuType STANDARD_V2 = fromString("StandardV2");

    /**
     * Creates a new instance of SkuType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SkuType() {
    }

    /**
     * Creates or finds a SkuType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SkuType.
     */
    public static SkuType fromString(String name) {
        return fromString(name, SkuType.class);
    }

    /**
     * Gets known SkuType values.
     * 
     * @return known SkuType values.
     */
    public static Collection<SkuType> values() {
        return values(SkuType.class);
    }
}
