// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.SubscriptionCreateParameterProperties;
import java.io.IOException;

/**
 * Subscription create details.
 */
@Fluent
public final class SubscriptionCreateParameters implements JsonSerializable<SubscriptionCreateParameters> {
    /*
     * Subscription contract properties.
     */
    private SubscriptionCreateParameterProperties innerProperties;

    /**
     * Creates an instance of SubscriptionCreateParameters class.
     */
    public SubscriptionCreateParameters() {
    }

    /**
     * Get the innerProperties property: Subscription contract properties.
     * 
     * @return the innerProperties value.
     */
    private SubscriptionCreateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the ownerId property: User (user id path) for whom subscription is being created in form /users/{userId}.
     * 
     * @return the ownerId value.
     */
    public String ownerId() {
        return this.innerProperties() == null ? null : this.innerProperties().ownerId();
    }

    /**
     * Set the ownerId property: User (user id path) for whom subscription is being created in form /users/{userId}.
     * 
     * @param ownerId the ownerId value to set.
     * @return the SubscriptionCreateParameters object itself.
     */
    public SubscriptionCreateParameters withOwnerId(String ownerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionCreateParameterProperties();
        }
        this.innerProperties().withOwnerId(ownerId);
        return this;
    }

    /**
     * Get the scope property: Scope like /products/{productId} or /apis or /apis/{apiId}.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: Scope like /products/{productId} or /apis or /apis/{apiId}.
     * 
     * @param scope the scope value to set.
     * @return the SubscriptionCreateParameters object itself.
     */
    public SubscriptionCreateParameters withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionCreateParameterProperties();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the displayName property: Subscription name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Subscription name.
     * 
     * @param displayName the displayName value to set.
     * @return the SubscriptionCreateParameters object itself.
     */
    public SubscriptionCreateParameters withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionCreateParameterProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the primaryKey property: Primary subscription key. If not specified during request key will be generated
     * automatically.
     * 
     * @return the primaryKey value.
     */
    public String primaryKey() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryKey();
    }

    /**
     * Set the primaryKey property: Primary subscription key. If not specified during request key will be generated
     * automatically.
     * 
     * @param primaryKey the primaryKey value to set.
     * @return the SubscriptionCreateParameters object itself.
     */
    public SubscriptionCreateParameters withPrimaryKey(String primaryKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionCreateParameterProperties();
        }
        this.innerProperties().withPrimaryKey(primaryKey);
        return this;
    }

    /**
     * Get the secondaryKey property: Secondary subscription key. If not specified during request key will be generated
     * automatically.
     * 
     * @return the secondaryKey value.
     */
    public String secondaryKey() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryKey();
    }

    /**
     * Set the secondaryKey property: Secondary subscription key. If not specified during request key will be generated
     * automatically.
     * 
     * @param secondaryKey the secondaryKey value to set.
     * @return the SubscriptionCreateParameters object itself.
     */
    public SubscriptionCreateParameters withSecondaryKey(String secondaryKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionCreateParameterProperties();
        }
        this.innerProperties().withSecondaryKey(secondaryKey);
        return this;
    }

    /**
     * Get the state property: Initial subscription state. If no value is specified, subscription is created with
     * Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is
     * blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been
     * made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been
     * denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator,
     * * expired – the subscription reached its expiration date and was deactivated.
     * 
     * @return the state value.
     */
    public SubscriptionState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Initial subscription state. If no value is specified, subscription is created with
     * Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is
     * blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been
     * made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been
     * denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator,
     * * expired – the subscription reached its expiration date and was deactivated.
     * 
     * @param state the state value to set.
     * @return the SubscriptionCreateParameters object itself.
     */
    public SubscriptionCreateParameters withState(SubscriptionState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionCreateParameterProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the allowTracing property: Determines whether tracing can be enabled.
     * 
     * @return the allowTracing value.
     */
    public Boolean allowTracing() {
        return this.innerProperties() == null ? null : this.innerProperties().allowTracing();
    }

    /**
     * Set the allowTracing property: Determines whether tracing can be enabled.
     * 
     * @param allowTracing the allowTracing value to set.
     * @return the SubscriptionCreateParameters object itself.
     */
    public SubscriptionCreateParameters withAllowTracing(Boolean allowTracing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubscriptionCreateParameterProperties();
        }
        this.innerProperties().withAllowTracing(allowTracing);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionCreateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionCreateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionCreateParameters.
     */
    public static SubscriptionCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionCreateParameters deserializedSubscriptionCreateParameters = new SubscriptionCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedSubscriptionCreateParameters.innerProperties
                        = SubscriptionCreateParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionCreateParameters;
        });
    }
}
