// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

/**
 * Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is
 * blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made
 * by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by
 * an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired –
 * the subscription reached its expiration date and was deactivated.
 */
public enum SubscriptionState {
    /**
     * Enum value suspended.
     */
    SUSPENDED("suspended"),

    /**
     * Enum value active.
     */
    ACTIVE("active"),

    /**
     * Enum value expired.
     */
    EXPIRED("expired"),

    /**
     * Enum value submitted.
     */
    SUBMITTED("submitted"),

    /**
     * Enum value rejected.
     */
    REJECTED("rejected"),

    /**
     * Enum value cancelled.
     */
    CANCELLED("cancelled");

    /**
     * The actual serialized value for a SubscriptionState instance.
     */
    private final String value;

    SubscriptionState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SubscriptionState instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SubscriptionState object, or null if unable to parse.
     */
    public static SubscriptionState fromString(String value) {
        if (value == null) {
            return null;
        }
        SubscriptionState[] items = SubscriptionState.values();
        for (SubscriptionState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
