// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Subscriptions delegation settings properties.
 */
@Fluent
public final class SubscriptionsDelegationSettingsProperties
    implements JsonSerializable<SubscriptionsDelegationSettingsProperties> {
    /*
     * Enable or disable delegation for subscriptions.
     */
    private Boolean enabled;

    /**
     * Creates an instance of SubscriptionsDelegationSettingsProperties class.
     */
    public SubscriptionsDelegationSettingsProperties() {
    }

    /**
     * Get the enabled property: Enable or disable delegation for subscriptions.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Enable or disable delegation for subscriptions.
     * 
     * @param enabled the enabled value to set.
     * @return the SubscriptionsDelegationSettingsProperties object itself.
     */
    public SubscriptionsDelegationSettingsProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionsDelegationSettingsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionsDelegationSettingsProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionsDelegationSettingsProperties.
     */
    public static SubscriptionsDelegationSettingsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionsDelegationSettingsProperties deserializedSubscriptionsDelegationSettingsProperties
                = new SubscriptionsDelegationSettingsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedSubscriptionsDelegationSettingsProperties.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionsDelegationSettingsProperties;
        });
    }
}
