// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.TagApiLinkContractInner;

/**
 * An immutable client-side representation of TagApiLinkContract.
 */
public interface TagApiLinkContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the apiId property: Full resource Id of an API.
     * 
     * @return the apiId value.
     */
    String apiId();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.TagApiLinkContractInner object.
     * 
     * @return the inner object.
     */
    TagApiLinkContractInner innerModel();

    /**
     * The entirety of the TagApiLinkContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The TagApiLinkContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the TagApiLinkContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the TagApiLinkContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, tagId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param tagId Tag identifier. Must be unique in the current API Management service instance.
             * @return the next definition stage.
             */
            WithCreate withExistingTag(String resourceGroupName, String serviceName, String tagId);
        }

        /**
         * The stage of the TagApiLinkContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithApiId {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            TagApiLinkContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            TagApiLinkContract create(Context context);
        }

        /**
         * The stage of the TagApiLinkContract definition allowing to specify apiId.
         */
        interface WithApiId {
            /**
             * Specifies the apiId property: Full resource Id of an API..
             * 
             * @param apiId Full resource Id of an API.
             * @return the next definition stage.
             */
            WithCreate withApiId(String apiId);
        }
    }

    /**
     * Begins update for the TagApiLinkContract resource.
     * 
     * @return the stage of resource update.
     */
    TagApiLinkContract.Update update();

    /**
     * The template for TagApiLinkContract update.
     */
    interface Update extends UpdateStages.WithApiId {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        TagApiLinkContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        TagApiLinkContract apply(Context context);
    }

    /**
     * The TagApiLinkContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the TagApiLinkContract update allowing to specify apiId.
         */
        interface WithApiId {
            /**
             * Specifies the apiId property: Full resource Id of an API..
             * 
             * @param apiId Full resource Id of an API.
             * @return the next definition stage.
             */
            Update withApiId(String apiId);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    TagApiLinkContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    TagApiLinkContract refresh(Context context);
}
