// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.TagContractProperties;
import java.io.IOException;

/**
 * Parameters supplied to Create/Update Tag operations.
 */
@Fluent
public final class TagCreateUpdateParameters implements JsonSerializable<TagCreateUpdateParameters> {
    /*
     * Properties supplied to Create Tag operation.
     */
    private TagContractProperties innerProperties;

    /**
     * Creates an instance of TagCreateUpdateParameters class.
     */
    public TagCreateUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Properties supplied to Create Tag operation.
     * 
     * @return the innerProperties value.
     */
    private TagContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the displayName property: Tag name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Tag name.
     * 
     * @param displayName the displayName value to set.
     * @return the TagCreateUpdateParameters object itself.
     */
    public TagCreateUpdateParameters withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TagContractProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagCreateUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagCreateUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TagCreateUpdateParameters.
     */
    public static TagCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagCreateUpdateParameters deserializedTagCreateUpdateParameters = new TagCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedTagCreateUpdateParameters.innerProperties = TagContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagCreateUpdateParameters;
        });
    }
}
