// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.TagDescriptionContractInner;
import java.io.IOException;
import java.util.List;

/**
 * Paged TagDescription list representation.
 */
@Fluent
public final class TagDescriptionCollection implements JsonSerializable<TagDescriptionCollection> {
    /*
     * Page values.
     */
    private List<TagDescriptionContractInner> value;

    /*
     * Total record count number across all pages.
     */
    private Long count;

    /*
     * Next page link if any.
     */
    private String nextLink;

    /**
     * Creates an instance of TagDescriptionCollection class.
     */
    public TagDescriptionCollection() {
    }

    /**
     * Get the value property: Page values.
     * 
     * @return the value value.
     */
    public List<TagDescriptionContractInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Page values.
     * 
     * @param value the value value to set.
     * @return the TagDescriptionCollection object itself.
     */
    public TagDescriptionCollection withValue(List<TagDescriptionContractInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the count property: Total record count number across all pages.
     * 
     * @return the count value.
     */
    public Long count() {
        return this.count;
    }

    /**
     * Set the count property: Total record count number across all pages.
     * 
     * @param count the count value to set.
     * @return the TagDescriptionCollection object itself.
     */
    public TagDescriptionCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the nextLink property: Next page link if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Next page link if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the TagDescriptionCollection object itself.
     */
    public TagDescriptionCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagDescriptionCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagDescriptionCollection if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TagDescriptionCollection.
     */
    public static TagDescriptionCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagDescriptionCollection deserializedTagDescriptionCollection = new TagDescriptionCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TagDescriptionContractInner> value
                        = reader.readArray(reader1 -> TagDescriptionContractInner.fromJson(reader1));
                    deserializedTagDescriptionCollection.value = value;
                } else if ("count".equals(fieldName)) {
                    deserializedTagDescriptionCollection.count = reader.getNullable(JsonReader::getLong);
                } else if ("nextLink".equals(fieldName)) {
                    deserializedTagDescriptionCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagDescriptionCollection;
        });
    }
}
