// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.TagDescriptionContractInner;

/**
 * An immutable client-side representation of TagDescriptionContract.
 */
public interface TagDescriptionContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the tagId property: Identifier of the tag in the form of /tags/{tagId}.
     * 
     * @return the tagId value.
     */
    String tagId();

    /**
     * Gets the displayName property: Tag name.
     * 
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the description property: Description of the Tag.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the externalDocsUrl property: Absolute URL of external resources describing the tag.
     * 
     * @return the externalDocsUrl value.
     */
    String externalDocsUrl();

    /**
     * Gets the externalDocsDescription property: Description of the external resources describing the tag.
     * 
     * @return the externalDocsDescription value.
     */
    String externalDocsDescription();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.TagDescriptionContractInner object.
     * 
     * @return the inner object.
     */
    TagDescriptionContractInner innerModel();

    /**
     * The entirety of the TagDescriptionContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The TagDescriptionContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the TagDescriptionContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the TagDescriptionContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, apiId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param apiId API revision identifier. Must be unique in the current API Management service instance.
             * Non-current revision has ;rev=n as a suffix where n is the revision number.
             * @return the next definition stage.
             */
            WithCreate withExistingApi(String resourceGroupName, String serviceName, String apiId);
        }

        /**
         * The stage of the TagDescriptionContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithDescription, DefinitionStages.WithExternalDocsUrl,
            DefinitionStages.WithExternalDocsDescription, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            TagDescriptionContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            TagDescriptionContract create(Context context);
        }

        /**
         * The stage of the TagDescriptionContract definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description of the Tag..
             * 
             * @param description Description of the Tag.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the TagDescriptionContract definition allowing to specify externalDocsUrl.
         */
        interface WithExternalDocsUrl {
            /**
             * Specifies the externalDocsUrl property: Absolute URL of external resources describing the tag..
             * 
             * @param externalDocsUrl Absolute URL of external resources describing the tag.
             * @return the next definition stage.
             */
            WithCreate withExternalDocsUrl(String externalDocsUrl);
        }

        /**
         * The stage of the TagDescriptionContract definition allowing to specify externalDocsDescription.
         */
        interface WithExternalDocsDescription {
            /**
             * Specifies the externalDocsDescription property: Description of the external resources describing the
             * tag..
             * 
             * @param externalDocsDescription Description of the external resources describing the tag.
             * @return the next definition stage.
             */
            WithCreate withExternalDocsDescription(String externalDocsDescription);
        }

        /**
         * The stage of the TagDescriptionContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the TagDescriptionContract resource.
     * 
     * @return the stage of resource update.
     */
    TagDescriptionContract.Update update();

    /**
     * The template for TagDescriptionContract update.
     */
    interface Update extends UpdateStages.WithDescription, UpdateStages.WithExternalDocsUrl,
        UpdateStages.WithExternalDocsDescription, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        TagDescriptionContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        TagDescriptionContract apply(Context context);
    }

    /**
     * The TagDescriptionContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the TagDescriptionContract update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description of the Tag..
             * 
             * @param description Description of the Tag.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the TagDescriptionContract update allowing to specify externalDocsUrl.
         */
        interface WithExternalDocsUrl {
            /**
             * Specifies the externalDocsUrl property: Absolute URL of external resources describing the tag..
             * 
             * @param externalDocsUrl Absolute URL of external resources describing the tag.
             * @return the next definition stage.
             */
            Update withExternalDocsUrl(String externalDocsUrl);
        }

        /**
         * The stage of the TagDescriptionContract update allowing to specify externalDocsDescription.
         */
        interface WithExternalDocsDescription {
            /**
             * Specifies the externalDocsDescription property: Description of the external resources describing the
             * tag..
             * 
             * @param externalDocsDescription Description of the external resources describing the tag.
             * @return the next definition stage.
             */
            Update withExternalDocsDescription(String externalDocsDescription);
        }

        /**
         * The stage of the TagDescriptionContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    TagDescriptionContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    TagDescriptionContract refresh(Context context);
}
