// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.TagOperationLinkContractInner;

/**
 * An immutable client-side representation of TagOperationLinkContract.
 */
public interface TagOperationLinkContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the operationId property: Full resource Id of an API operation.
     * 
     * @return the operationId value.
     */
    String operationId();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.TagOperationLinkContractInner object.
     * 
     * @return the inner object.
     */
    TagOperationLinkContractInner innerModel();

    /**
     * The entirety of the TagOperationLinkContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The TagOperationLinkContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the TagOperationLinkContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the TagOperationLinkContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, tagId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param tagId Tag identifier. Must be unique in the current API Management service instance.
             * @return the next definition stage.
             */
            WithCreate withExistingTag(String resourceGroupName, String serviceName, String tagId);
        }

        /**
         * The stage of the TagOperationLinkContract definition which contains all the minimum required properties for
         * the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithOperationId {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            TagOperationLinkContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            TagOperationLinkContract create(Context context);
        }

        /**
         * The stage of the TagOperationLinkContract definition allowing to specify operationId.
         */
        interface WithOperationId {
            /**
             * Specifies the operationId property: Full resource Id of an API operation..
             * 
             * @param operationId Full resource Id of an API operation.
             * @return the next definition stage.
             */
            WithCreate withOperationId(String operationId);
        }
    }

    /**
     * Begins update for the TagOperationLinkContract resource.
     * 
     * @return the stage of resource update.
     */
    TagOperationLinkContract.Update update();

    /**
     * The template for TagOperationLinkContract update.
     */
    interface Update extends UpdateStages.WithOperationId {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        TagOperationLinkContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        TagOperationLinkContract apply(Context context);
    }

    /**
     * The TagOperationLinkContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the TagOperationLinkContract update allowing to specify operationId.
         */
        interface WithOperationId {
            /**
             * Specifies the operationId property: Full resource Id of an API operation..
             * 
             * @param operationId Full resource Id of an API operation.
             * @return the next definition stage.
             */
            Update withOperationId(String operationId);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    TagOperationLinkContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    TagOperationLinkContract refresh(Context context);
}
