// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.TagProductLinkContractInner;
import java.io.IOException;
import java.util.List;

/**
 * Paged Tag-product link list representation.
 */
@Fluent
public final class TagProductLinkCollection implements JsonSerializable<TagProductLinkCollection> {
    /*
     * Page values.
     */
    private List<TagProductLinkContractInner> value;

    /*
     * Total record count number across all pages.
     */
    private Long count;

    /*
     * Next page link if any.
     */
    private String nextLink;

    /**
     * Creates an instance of TagProductLinkCollection class.
     */
    public TagProductLinkCollection() {
    }

    /**
     * Get the value property: Page values.
     * 
     * @return the value value.
     */
    public List<TagProductLinkContractInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Page values.
     * 
     * @param value the value value to set.
     * @return the TagProductLinkCollection object itself.
     */
    public TagProductLinkCollection withValue(List<TagProductLinkContractInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the count property: Total record count number across all pages.
     * 
     * @return the count value.
     */
    public Long count() {
        return this.count;
    }

    /**
     * Set the count property: Total record count number across all pages.
     * 
     * @param count the count value to set.
     * @return the TagProductLinkCollection object itself.
     */
    public TagProductLinkCollection withCount(Long count) {
        this.count = count;
        return this;
    }

    /**
     * Get the nextLink property: Next page link if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Next page link if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the TagProductLinkCollection object itself.
     */
    public TagProductLinkCollection withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagProductLinkCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagProductLinkCollection if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TagProductLinkCollection.
     */
    public static TagProductLinkCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagProductLinkCollection deserializedTagProductLinkCollection = new TagProductLinkCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TagProductLinkContractInner> value
                        = reader.readArray(reader1 -> TagProductLinkContractInner.fromJson(reader1));
                    deserializedTagProductLinkCollection.value = value;
                } else if ("count".equals(fieldName)) {
                    deserializedTagProductLinkCollection.count = reader.getNullable(JsonReader::getLong);
                } else if ("nextLink".equals(fieldName)) {
                    deserializedTagProductLinkCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagProductLinkCollection;
        });
    }
}
